# -*- coding: utf-8 -*-
"""
Created on Tue Jul  4 15:59:41 2023

@author: 20172893
"""

# import h5py
# #from scipy.fft import fft, fftfreq
# from scipy.optimize import curve_fit
# import matplotlib.colors as mcolors
# from scipy.interpolate import UnivariateSpline

#%% Packages
import numpy as np
import matplotlib.pyplot as plt
import os
import glob
import re
from scipy import signal
import scipy.fft as sfft
import scipy.constants as c
import pandas as pd
import scipy.interpolate as spi
import matplotlib.cm as cm
from matplotlib import ticker
from lmfit import Model, Parameter
import matplotlib.colors as mcolors
from scipy.interpolate import UnivariateSpline
from scipy.integrate import solve_ivp, odeint
from scipy.optimize import curve_fit
#%% Definitions
# This will find the a number or float after a certain string in a filename, say use 'P=' in front of the laser power
def find_float(text, c):
    return re.findall(r"%s(?:\d*\.*\d+)" % c, text)
def find_number(text, c):
    return re.findall(r'%s(\d+)' % c, text)

# This function takes a sorted array and a value and returns the element closest to the value
def findNearestSorted(array, value):
    idx = np.searchsorted(array, value)
    if array[idx] - value > np.diff(array).mean() * 0.5:
        idx -= 1
    return idx


# This function takes an array and a value and returns the element closest to the value
def findNearest(array, value):
    array = np.asarray(array)
    return (np.abs(array - value)).argmin()

def time_to_element(time, timeresolution):
    return time / (timeresolution)


# This will remove all zeros from interferogram dataset
def cleaning_zeros(MAParray,TimeAxis):
    MAParray = np.roll(MAParray,-1,axis=1)
    mask = np.max(np.argmax(MAParray[:,::-1][:,1:]>1e-3,axis=1))
    limit = TimeAxis.size-mask-2
    MAParray = MAParray[:,:limit]
    TimeAxis = TimeAxis[:limit]
    return MAParray,TimeAxis

# Definitions for Bg correction for interferograms (or also spectrum) map
def get_ZPD_pos(data, method="max"):
    if method == "max":
        return np.argmax(data)
    if method == "zero":
        return np.argmin(np.abs(data))
    if method == "absmax":
        return np.argmax(np.abs(data))
    return np.argmax(data)

def bg_correction(MAParray, method='linear', bi=False):
    if bi != True:
        return signal.detrend(MAParray, axis=0, type=method)
    total_ifg = np.sum(MAParray, axis=1)
    ZPD_pos = get_ZPD_pos(total_ifg)
    return signal.detrend(MAParray, axis=0, type=method, bp=[ZPD_pos])

# Definition for phase correction
def apodization_function(pos, interferogram, method="Blackman-Harris-3", width=None, ZPD="Max"):
    if width is None:
        width = np.max(pos)
    if ZPD == "Max":
        ZPD_pos = pos[np.argmax(interferogram)]
    else:
        ZPD_pos = pos[np.argmin(np.abs(pos))]
    x = (pos - ZPD_pos) / width
    if method == 'Boxcar':
        apodization = np.ones_like(pos)
    if method == 'Triangular':
        apodization = 1 - np.abs(x)
    if method == 'Happ-Genzel':
        apodization = 0.54 + 0.46 * np.cos(np.pi * x)
    if method == 'Cosine':
        apodization = np.cos(np.pi / 2 * x)
    if method == 'Lorentz':
        apodization = np.exp(-np.abs(x))
    if method == 'Gaussian':
        apodization = np.exp(-np.square(2.24 * x))
    if method == 'Blackman-Harris-3':
        apodization = 0.42323 + 0.49755 * np.cos(np.pi * x) + 0.07922 * np.cos(2 * np.pi * x)
    if method == 'Blackman-Harris-4':
        apodization = 0.35875 + 0.48829 * np.cos(np.pi * x) + 0.14128 * np.cos(2 * np.pi * x) + 0.01168 * np.cos(
            3 * np.pi * x)
    apodization[np.abs(x) >= 1] = 0
    return apodization

def apodization_correction(pos, interferogram_map, **kwargs):
    total_ifg = np.sum(interferogram_map, axis=1)
    apodization_curve = apodization_function(pos, total_ifg, **kwargs)
    return interferogram_map * apodization_curve[:, np.newaxis], apodization_curve

def rotate_interferogram(pos, interferogram, zero_filling_factor):
    if len(interferogram.shape) > 1:
        Total_Interferogram = np.sum(interferogram, axis=1)
    else:
        Total_Interferogram = interferogram
    maximum = get_ZPD_pos(Total_Interferogram)
    ZF_len = sfft.next_fast_len(zero_filling_factor * pos.size, real=True)
    print(pos.size, ZF_len, interferogram.shape)

    if len(interferogram.shape) > 1:
        Rotated_Interferogram = np.zeros([ZF_len, interferogram.shape[1]])
        Rotated_Interferogram[:interferogram.shape[0], :] = interferogram
    else:
        Rotated_Interferogram = np.zeros(ZF_len)
        Rotated_Interferogram[:interferogram.size] = interferogram
    Rotated_Interferogram = np.roll(Rotated_Interferogram, -maximum, axis=0)
    return Rotated_Interferogram

def get_phase_correction_angles(PosAxis, interferogram_map, reduction=1, zero_filling=8):
    total_Interferogram = np.sum(interferogram_map, axis=1)
    ZPD_index = get_ZPD_pos(total_Interferogram)
    Phase_PosAxis = (PosAxis - PosAxis[ZPD_index])[:2 * ZPD_index]
    Phase_Interferogram = total_Interferogram[:2 * ZPD_index]
    Phase_Interferogram = apodization_correction(Phase_PosAxis, Phase_Interferogram[:, np.newaxis], method="Triangular",
                                                 width=Phase_PosAxis[-1] / reduction)[0][:, 0]
    fft_data = rotate_interferogram(PosAxis, Phase_Interferogram, zero_filling)
    Phase_Spectrum = sfft.rfft(fft_data)
    return np.angle(Phase_Spectrum)

# Definitions for Interferograms to spectrums
def asymmetric_interferogram_correction(interferogram_map, method="poly", ZPD_index=None):
    if len(interferogram_map.shape) > 1:
        total_Interferogram = np.sum(interferogram_map, axis=1)
    else:
        total_Interferogram = interferogram_map
    if ZPD_index is None:
        ZPD_index = get_ZPD_pos(total_Interferogram)

    ramp = np.ones([total_Interferogram.size])
    if method == "ramp":
        ramp[:ZPD_index * 2] = np.linspace(0, 1, ZPD_index * 2)
    else:
        rampx = np.linspace(-1, 1, ZPD_index * 2)
        ramp[:ZPD_index * 2] = 0.5 + 1.25 * rampx ** 3 - 0.75 * rampx ** 5

    if len(interferogram_map.shape) > 1:
        return interferogram_map * ramp[:, np.newaxis]
    else:
        return interferogram_map * ramp

def get_calibrated_spectrum_map(pos, interferogram_map, zero_filling_factor=4, phase_corr_angle=None):
    hc = c.h * c.c / c.e * 1e9

    df = pd.read_csv('C:/Users\s140040\Documents\scripts\TRES analysis/202301003_parameters_cal.txt', sep='\t', index_col=0, header=None, dtype='float64').T
    df.columns = ["WL", "PF"]
    df["E"] = hc / df["WL"]
    df = df.groupby("PF", as_index=False).mean()

    f = spi.InterpolatedUnivariateSpline(df["PF"], df["E"], k=2)
    inverse_f_prime = spi.UnivariateSpline(df["E"], df["PF"], k=5, s=0.4).derivative()

    # Get next fast FFT size
    nfast = sfft.next_fast_len(zero_filling_factor * pos.size, real=True)
    pseudo_freq = sfft.rfftfreq(nfast, d=(max(pos) - min(pos)) / len(pos))

    interferogram_map = asymmetric_interferogram_correction(interferogram_map)
    Rotated_map = rotate_interferogram(pos, interferogram_map, zero_filling_factor)
    # Perform the RFFT
    fft_map = sfft.rfft(Rotated_map, n=nfast, norm="ortho", axis=0)
    if phase_corr_angle is not None:
        fft_map *= np.exp(-phase_corr_angle * 1j)[:, np.newaxis]

    map_spectrum = np.real(fft_map)
    energy = f(pseudo_freq[pseudo_freq > np.min(df["PF"])])

    map_spectrum = map_spectrum[pseudo_freq > np.min(df["PF"]), :]

    print("pseudo", np.trapz(np.sum(map_spectrum, axis=1), pseudo_freq[pseudo_freq > np.min(df["PF"])]))
    TotalSpectrum = np.sum(map_spectrum, axis=1)
    TotalSpectrumCorr = TotalSpectrum * inverse_f_prime(energy)
    print("E", np.trapz(TotalSpectrumCorr, energy))

    map_spectrum *= inverse_f_prime(energy)[:, np.newaxis]

    # Conversion to wavelength and jacobian matrix element correction
    wavelength = hc / energy
    map_spectrum_wave = np.copy(map_spectrum)
    map_spectrum_wave *= (hc / np.square(wavelength))[:, np.newaxis]

    return energy, map_spectrum, wavelength, map_spectrum_wave

##### Definitions for dispersion calibration ####
def dispersion_calibration_E(energy, spectrum_map_ET, time):
    debug = False
    #coeffs = [1.37248621e-14, -1.22298044e-10, 4.34002791e-07, -7.65740020e-04, 6.71167610e-01, -2.21779435e+02]
    #coeffs = [-21.82863, 55.13611, -46.73688, 13]
    coeffs = [-2987.344, 10652.947, -15146.978, 10738.12312, -3798.627, 12]
    p = np.poly1d(coeffs)
    #QW_start_wav, QW_end_wav = 1600, 2190
    QW_start_E, QW_end_E = 0.6, 0.8
    #wavelengths = 1238/energy
    #print(wavelengths)

    p_values = p(energy)
    p_values[energy < QW_start_E] = p(QW_start_E)
    p_values[energy > QW_end_E] = p(QW_end_E)  # + p.deriv(1)(QW_end) * (wave[wave > QW_end] - QW_end)

    if debug is True:
        plt.plot(energy, p_values)
        plt.show()

    #indexes = time_to_element(p_values, time[4] - time[3])
    indexes = p_values/0.004
    print(indexes)

    if debug is True:
        plt.plot(energy, indexes)
        plt.show()

    # plt.plot(wave, indexes)
    print(spectrum_map_ET.shape[0])
    print(spectrum_map_ET.shape[1])
    calibrated_map_E =  np.zeros_like(spectrum_map_ET)
    for i in range(spectrum_map_ET.shape[0]):
        calibrated_map_E[i, :] = np.roll(spectrum_map_ET[i, :], -int(indexes[i]))

    return calibrated_map_E


####function to average over several time bins together
# Define the number of neighboring values to include in the average
def average_time_bins(map_spectrum, energy_axis, TimeAxis, num_neighbors):
    time_res = TimeAxis[5]-TimeAxis[4]
    t_res=(num_neighbors*2+1)*time_res
    tres='_timeres'+ str(t_res)
    num_rows=len(TimeAxis)
    num_cols=len(energy_axis)

    #matrix=np.random.randint(0,5,size = (num_rows,num_cols))
    #matrix=np.random.random((num_rows, num_cols))
    #print(matrix)
    # Initialize the output matrix with zeros
    avg_map_spectrum_red = np.zeros_like(map_spectrum, dtype=float)

    # Iterate over the columns of the input matrix
    for j in range(num_cols-1):
        # Iterate over the rows of the input matrix
        for i in range(num_rows-1):

            # Define the range of row indices to include in the average
            start_i = max(0, i - num_neighbors)
            end_i = min(num_rows-1, i + num_neighbors + 1)

            # Compute the average of the neighboring values in the column
            avg_value = np.mean(map_spectrum[j, start_i:end_i])

            #avg_value = np.sum(matrix[start_i:end_i, j])/(2*num_neighbors+1)

            # Set the corresponding element of the output matrix to the average value
            avg_map_spectrum_red[j, i] = avg_value

    return tres, avg_map_spectrum_red

# Function which output the time for which the initial time between time_start and time_end (in ns),
def find_initial_time(TRES_map, time_axis, time_start, time_end):
    # Time region to find maximum values
    time_res = (time_axis[4] - time_axis[3]) / 1000  # ns,  this is the time resolution used in measurement

    element_start = time_start / time_res
    element_end = time_end / time_res

    ShapeMap = TRES_map.shape
    Columns = ShapeMap[1]

    MAParray_red = TRES_map
    k = Columns - 1
    # delete last columns
    while k > element_end:
        MAParray_red = np.delete(MAParray_red, k, 1)
        k = k - 1

    j = 0
    # delete first colums
    while j < element_start:
        # deletes first column until columns are deleted until element start
        MAParray_red = np.delete(MAParray_red, 0, 1)
        j = j + 1

    # Finds times and wavelength for maximum values, but with element_start time displaced
    InitElements = np.argmax(MAParray_red, axis=1)

    # corrects displacement
    InitTimes = (InitElements + element_start) * time_res

    return InitTimes

def Boltzman(E, init_E, y0, A, Te):
    kb=0.00008617
    return y0 + A * np.exp(-(E - init_E) / (kb*Te))

def FermiDirac(E, init_E, y0, A, Te, mu):
    kb=0.00008617
    return y0 + A *(1/ (np.exp(((E - init_E)-mu) / (kb*Te))+1))

def LSW(E, init_E, Eg, deltamu, Tc, A2, y0, w):
    kb=8.617E-5
    h=4.135E-15
    c=2.99792E8
    pi=np.pi
    Gaussian = True
    JDOS = np.zeros_like(E)
    if Gaussian is True:
        Gauss = np.exp(-(E - Eg) ** 2 / (2*w**2))  # extra Gaussian broadening around bandgap to include alloy broadening and subbandgap states
        i = 0
        while E[i] < Eg:
            JDOS = np.exp(-(E[i] - Eg) ** 2 / (2*w**2))
            i = i+1

        while E[i] >= Eg:
            JDOS = np.heaviside(Eg,1)  #DOS is a heaviside function with a step at the "bandgap" of the material with height 1 (the actual amplitude is in the prefactor A in the total equation)
            if i < len(E)-1:
                i = i+1
            else:
                break

    if Gaussian is False:
        Gauss = 1
        JDOS[E > Eg] = np.heaviside(Eg,1)  # DOS is a heaviside function with a step at the "bandgap" of the material with height 1 (the actual amplitude is in the prefactor A in the total equation)

    epsilon = (E-deltamu)/(kb*Tc)
    epsilon[np.abs(E-deltamu)<10**-11]=10**-11

    function = (10**A2)*((2*pi)/((h**3)*(c**2)))*((((E - init_E)**2)*(JDOS))/(np.exp(epsilon)-1))*(1-(2/(np.exp(epsilon/2)+1)))+y0
    return function

def monoexpdecay(t, init_t, y0, A1, tau1):
    return y0 + A1 * np.exp(-(t - init_t) / tau1)


def biexpdecay(t, init_t, y0, A1, A2, tau1, tau2, Deltatau):
    return y0 + A1 * np.exp(-(t - init_t) / tau1) + A2 * np.exp(-(t - init_t) / tau2)

def plot_spectra_per_time(negative_time, positive_time, time_interval_of_interest, init_time, map_spectrum_E_red, E_red):
    average_initial_time=init_time
    time_res = (TimeAxis[4] - TimeAxis[3])/1e3
    time_of_interest=np.arange(negative_time/time_interval_of_interest, positive_time/time_interval_of_interest)*time_interval_of_interest
    #time_of_interest = np.arange(-16, 80) * time_interval_of_interest
    #time_of_interest_element = np.round(time_to_element(time_of_interest + average_initial_time, time_res)).astype(int)
    time_of_interest_element = time_to_element(time_of_interest + average_initial_time, time_res).astype(int)
    #time_of_interest_element = time_to_element(time_of_interest, time_res).astype(int)


   ####Plot spectra over time ####
    fig, ax = plt.subplots(figsize=(12, 8))
    ax.set_xlabel('Energy (eV))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)

    color_map = plt.get_cmap('rainbow')
    normalize = mcolors.Normalize(vmin=time_of_interest.min(), vmax=time_of_interest.max()) # create a color scale from the minimum to maximum time values
    colormap = cm.jet

    map_spectrum_E_red_T=np.transpose(map_spectrum_E_red)

    for i in range(len(time_of_interest)):
        intensity = map_spectrum_E_red_T[time_of_interest_element[i], :]
        ax.plot(E_red, intensity, label=str(time_of_interest[i]) + ' ns', color=color_map(i/len(time_of_interest)))
    ax.set_xlabel('Energy (eV))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    #ax.legend()
    # setup the colorbar
    scalarmappaple = cm.ScalarMappable(norm=normalize, cmap=colormap)
    scalarmappaple.set_array(time_of_interest)
    clb = plt.colorbar(scalarmappaple)
    clb.set_label('time (ns)', fontweight ='bold', labelpad=-30, y=1.05, rotation=0, fontsize=15)
    #cbar.set_label('Time (ns)', fontweight ='bold', rotation=270)
    plt.savefig(save_directory_metadata+"/spectra over time.png")
    plt.show()
    
   ####Plot spectra over time normalized####
    fig, ax = plt.subplots(figsize=(12, 8))
    ax.set_xlabel('Energy (eV))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)

    color_map = plt.get_cmap('rainbow')
    normalize = mcolors.Normalize(vmin=time_of_interest.min(), vmax=time_of_interest.max()) # create a color scale from the minimum to maximum time values
    colormap = cm.jet
    for i in range(len(time_of_interest)):
        intensity = map_spectrum_E_red_T[time_of_interest_element[i], :]
        intensity_normalized = intensity / np.max(intensity)
        ax.plot(E_red, intensity_normalized, 
            label=str(time_of_interest[i]) + ' ns', 
            color=color_map(i/len(time_of_interest)))
    ax.set_xlabel('Energy (eV))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity Normalized', fontweight ='bold', fontsize=30)
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    # setup the colorbar
    scalarmappaple = cm.ScalarMappable(norm=normalize, cmap=colormap)
    scalarmappaple.set_array(time_of_interest)
    clb = plt.colorbar(scalarmappaple)
    clb.set_label('time (ns)', fontweight ='bold', labelpad=-30, y=1.05, rotation=0, fontsize=15)
    plt.savefig(save_directory_metadata+"/normalized spectra over time.png")
    plt.show()

    # Create an array to store the intensities for each time of interest

    intensity_array = []
    intensity_array_normalized = []

    # Loop through each time of interest and plot the corresponding intensity
    for i in range(len(time_of_interest)):
        intensity = map_spectrum_E_red_T[time_of_interest_element[i], :]
        ax.plot(E_red, intensity, 
            label=str(time_of_interest[i]) + ' ns', 
            color=color_map(i/len(time_of_interest)))
        intensity_array.append(intensity)

    # Loop through each time of interest and plot the corresponding intensity
    for i in range(len(time_of_interest)):
        intensity = map_spectrum_E_red_T[time_of_interest_element[i], :]
        intensity_normalized = intensity / np.max(intensity)
        ax.plot(E_red, intensity_normalized, 
            label=str(time_of_interest[i]) + ' ns', 
            color=color_map(i/len(time_of_interest)))
        intensity_array_normalized.append(intensity_normalized)
    
    #Save the plotted lines in the specified format
    np.savetxt(file_directory+  save_directory_spectra + file_name +  '_calibrated spectrum at specific times.txt',
                np.column_stack((E_red, *intensity_array)),
                header='Energy (eV),' + ', '.join('Intensity ' + str(t) + ' ns' for t in time_of_interest),
                delimiter=',')

    np.savetxt(file_directory+  save_directory_spectra + file_name +  '_calibrated spectrum at specific times_normalized.txt',
                np.column_stack((E_red, *intensity_array_normalized)),
                header='Energy (eV),' + ', '.join('Intensity ' + str(t) + ' ns' for t in time_of_interest),
                delimiter=',')
    
    return intensity_array, intensity_array_normalized        
    #return map_spectrum_E_red_T
    
def plot_intenisty_per_energy(energy_start, energy_end, energy_interval_of_interest, map_spectrum_E_red, E_red, TimeAxis, Ttime_start, Ttime_end, average_initial_time):
    
    TimeAxis = TimeAxis/1000  # converts ps time axis to ns
    # ns,  this is the time resolution used in measurement
    time_res = (TimeAxis[4] - TimeAxis[3]) #in ns --> Hebben we niet nodig nu
   # wave_res = (wavelength_axis_red[4]-wavelength_axis_red[3])
   # energy_res = (E_red[4]-E_red[3])
    
    # Select to the times wanted to fit Te to
    Ttime_start_real=average_initial_time+Ttime_start
    Ttime_end_real=average_initial_time+Ttime_end
    start_element_time = time_to_element(Ttime_start_real, time_res)
    start_element_time = start_element_time.astype(int)
    end_element_time = time_to_element(Ttime_end_real, time_res)
    end_element_time = end_element_time.astype(int)
    #start_element_time = findNearestSorted(TimeAxis,Ttime_start_real)
    #end_element_time = findNearestSorted(TimeAxis,Ttime_end_real)
    

    #map_spectrum_E_red_T=np.transpose(map_spectrum_E_red)                                     
    # map_spectrum_W_red with only the times of interest by deleting all other columns
    map_spectrum_E_red_red = map_spectrum_E_red[:,start_element_time:end_element_time]
    # reduced time axis
    TimeAxis_red = TimeAxis[start_element_time:end_element_time]
    TimeAxis = TimeAxis*1000
    
    energy_res = (E_red[4] - E_red[3])
    energy_of_interest=np.arange(energy_start/energy_interval_of_interest, energy_end/energy_interval_of_interest)*energy_interval_of_interest
    energy_of_interest_element = time_to_element(energy_of_interest-np.min(E_red), energy_res).astype(int)


   ####Plot spectra over time ####
    fig, ax = plt.subplots(figsize=(12, 8))
    ax.set_xlabel('time (ns)))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)

    color_map = plt.get_cmap('rainbow')
    normalize = mcolors.Normalize(vmin=energy_of_interest.min(), vmax=energy_of_interest.max()) # create a color scale from the minimum to maximum time values
    colormap = cm.jet



    for i in range(len(energy_of_interest)):
        intensity = map_spectrum_E_red_red[energy_of_interest_element[i], :]
        ax.plot(TimeAxis_red, intensity, label=str(energy_of_interest[i]) + ' eV', color=color_map(i/len(energy_of_interest)))
    ax.set_xlabel('time (ns))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    ax.set_yscale('log')
    #ax.legend()
    # setup the colorbar
    scalarmappaple = cm.ScalarMappable(norm=normalize, cmap=colormap)
    scalarmappaple.set_array(energy_of_interest)
    clb = plt.colorbar(scalarmappaple)
    clb.set_label('energy (eV)', fontweight ='bold', labelpad=-30, y=1.05, rotation=0, fontsize=15)
    #cbar.set_label('Time (ns)', fontweight ='bold', rotation=270)
    plt.savefig(save_directory_metadata+"/timedecay over energy.png")
    plt.show()

   ####Plot spectra over time normalized####
    fig, ax = plt.subplots(figsize=(12, 8))
    ax.set_xlabel('time (ns))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity (a.u.)', fontweight ='bold', fontsize=30)

    color_map = plt.get_cmap('rainbow')
    normalize = mcolors.Normalize(vmin=energy_of_interest.min(), vmax=energy_of_interest.max()) # create a color scale from the minimum to maximum time values
    colormap = cm.jet
    for i in range(len(energy_of_interest)):
        intensity = map_spectrum_E_red_red[energy_of_interest_element[i], :]
        intensity_normalized = intensity / np.max(intensity)
        ax.plot(TimeAxis_red, intensity_normalized, 
            label=str(energy_of_interest[i]) + ' ns', 
            color=color_map(i/len(energy_of_interest)))
    ax.set_xlabel('time (ns))', fontweight ='bold', fontsize=30)
    ax.set_ylabel('Intensity Normalized', fontweight ='bold', fontsize=30)
    ax.set_yscale('log')
    #ax.set_xscale('log')
    ax.set_ylim([0.01, 2])
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    ax.set_title(file_name, fontweight ='bold', fontsize=15)
    # setup the colorbar
    scalarmappaple = cm.ScalarMappable(norm=normalize, cmap=colormap)
    scalarmappaple.set_array(energy_of_interest)
    clb = plt.colorbar(scalarmappaple)
    clb.set_label('energy (eV)', fontweight ='bold', labelpad=-30, y=1.05, rotation=0, fontsize=15)
    plt.savefig(save_directory_metadata+"/normalized timedecay over energy.png")
    plt.show()

    # Create an array to store the intensities for each time of interest

    intensity_array = []
    intensity_array_normalized = []

    # Loop through each time of interest and plot the corresponding intensity
    for i in range(len(energy_of_interest)):
        intensity = map_spectrum_E_red_red[energy_of_interest_element[i], :]
        ax.plot(TimeAxis_red, intensity, 
            label=str(energy_of_interest[i]) + ' ns', 
            color=color_map(i/len(energy_of_interest)))
        intensity_array.append(intensity)

    # Loop through each time of interest and plot the corresponding intensity
    for i in range(len(energy_of_interest)):
        intensity = map_spectrum_E_red_red[energy_of_interest_element[i], :]
        intensity_normalized = intensity / np.max(intensity)
        ax.plot(TimeAxis_red, intensity_normalized, 
            label=str(energy_of_interest[i]) + ' ns', 
            color=color_map(i/len(energy_of_interest)))
        intensity_array_normalized.append(intensity_normalized)
    
    #Save the plotted lines in the specified format
    np.savetxt(file_directory+ save_directory_spectra + file_name + '_time decay at specific energies.txt',
                np.column_stack((TimeAxis_red, *intensity_array)),
                header='Time (ns),' + ', '.join('Intensity ' + str(t) + ' eV' for t in energy_of_interest),
                delimiter=',')

    np.savetxt(file_directory+  save_directory_spectra + file_name + '_time decay at specific energies_normalized.txt',
                np.column_stack((TimeAxis_red, *intensity_array_normalized)),
                header='Time (ns),' + ', '.join('Intensity ' + str(t) + ' eV' for t in energy_of_interest),
                delimiter=',')
    
    return intensity_array, intensity_array_normalized        
    #return map_spectrum_E_red_T
#%% Formulas
#### Te fits ####
def fit_Tefit_TRES(debug, map_spectrum, time_axis, energy_axis_red, Ttime_start, Ttime_end, average_initial_time,Typeoffit):
  

    # Type of fit (Boltzman=1 , Fermi Dirac=2)
    Type_of_fit = Typeoffit

    time_axis = time_axis/1000  # converts ps time axis to ns
    # ns,  this is the time resolution used in measurement
    time_res = (time_axis[4] - time_axis[3]) #in ns --> Hebben we niet nodig nu
   # wave_res = (wavelength_axis_red[4]-wavelength_axis_red[3])
   # energy_res = (energy_axis_red[4]-energy_axis_red[3])
    
    # Select to the times wanted to fit Te to
    Ttime_start_real=average_initial_time+Ttime_start
    Ttime_end_real=average_initial_time+Ttime_end
    start_element_time = time_to_element(Ttime_start_real, time_res)
    start_element_time = start_element_time.astype(int)
    end_element_time = time_to_element(Ttime_end_real, time_res)
    end_element_time = end_element_time.astype(int)
    #start_element_time = findNearestSorted(time_axis,Ttime_start_real)
    #end_element_time = findNearestSorted(time_axis,Ttime_end_real)
                                         
    # map_spectrum_W_red with only the times of interest by deleting all other columns
    map_spectrum_red_red = map_spectrum[:, start_element_time:end_element_time]
    # reduced time axis
    time_axis_red = time_axis[start_element_time:end_element_time]
    numbertime = len(time_axis_red)                                     


    fit_results_array = np.full([numbertime, 10], None)
    
    # will select each row to do the temperature fit on
    for k in range(map_spectrum_red_red.shape[1]):
        # extract temperature for each time
        Temperature_array = map_spectrum_red_red[:, k]
        time = time_axis_red[k]
        
        # start fit by finding 80% of maximum point and fit from there till end of the spectrum

        # region of interest for max
        max_energy_1 = Tenergy_start - 0.2  # eV (to account for red shift at positive times)
        #max_wavelength_1 = 1239.8/Tenergy_start  # nm
        #max_element_1 = max_wavelength_1 / wave_res
        #max_element_1 = max_energy_1 / energy_res - (max(energy_axis_red)/energy_res)
        max_element_1 = findNearest(energy_axis_red, max_energy_1)
        max_energy_2 = Tenergy_start + 0.15 # eV (to account for blue shift at negative times)
       #max_wavelength_2 = 1239.8/max_energy_2  # nm
       #max_element_2 = max_wavelength_2 / wave_res
        max_element_2 = findNearest(energy_axis_red, max_energy_2)
        endenergy = Tenergy_end  # eV
        endelement = findNearest(energy_axis_red, endenergy)

        if debug is True:
            print(max_element_1)
            print(max_element_2)
            print(endelement)
    
        
        # define x and y data
        # define start and end element of temperature fit --> Let op, hier zou iets veranderd moeten worden als het niet werkt
        # startelement = np.argmax(Temperature_array[int(round(max_element_2)):int(round(max_element_1))])+max_element_2
        maxvalue = np.max(Temperature_array[int(round(max_element_1)):int(round(max_element_2))])
        maxelement = findNearest(Temperature_array, maxvalue)
        startvalue = maxvalue
        
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        startelement = maxelement#+findNearest(Temperature_array[int(round(maxelement)):int(round(endelement))], startvalue)
        #startelement = findNearest(Temperature_array, startvalue)
        if debug is True:
            print("start checking max from "+str(max_element_1))
            print("start element with max is"+str(startelement))
            print("Which is energy" + str(findNearest(energy_axis_red, startelement)))
            print("with value"+str(maxvalue))

        #start_energy = energy_axis_red[startelement]
        start_energy = 0
        #start_energy = Temperature_array[startelement]
    # how many eV long the fit should be
    

 # Create axis
        x = energy_axis_red[int(startelement):int(endelement)] #Let op, omgedraaid ten opzichte van lifetimefit
        y = Temperature_array[int(startelement):int(endelement)] #Let op, omgedraaid ten opzichte van lifetimefit
 
 # initial values for the fit
        if Type_of_fit == 1:
            Decay_model = Model(Boltzman)
            init_E_0 = start_energy #start energy
            Te_0 = 340  # initial carrier temperature (K)
            A_0 = 1e+14  # initial amplitude decay 1
            y0_0 = 0
        elif Type_of_fit == 2:
            init_E_0 = start_energy #start energy
            Te_0 = 600  # initial carrier temperature (K)
            A_0 = 143  # initial amplitude decay 1
            y0_0 = 0
            mu_0 = 0.6 #initial fermi energy splitting
 
        #if Type_of_fit == 2:
            

 # first guess initial values order (E,Te, init_E, y0, A, mu)
        if Type_of_fit == 1:
            Decay_model = Model(Boltzman)
            result = Decay_model.fit(y, E=x, init_E=Parameter('initial energy (eV)', value=init_E_0, vary=False),
                              y0=Parameter('Baseline', value=y0_0, vary=False),
                              A=Parameter('A', value=A_0, min=0.01),
                              Te=Parameter('Carrier temperature (K)', value=Te_0, min=0.01))
        elif Type_of_fit == 2:
            Decay_model = Model(FermiDirac)
            result = Decay_model.fit(y, E=x, init_E=Parameter('initial energy (eV)', value=init_E_0, vary=False),
                              y0=Parameter('Baseline', value=y0_0, vary=False),
                              A=Parameter('A', value=A_0, min=0.00001),
                              Te=Parameter('Carrier temperature (K)', value=Te_0, min=0.01),
                              mu=Parameter('Fermi energy', value=mu_0, min=0))

                              
   # If debug is on, print fitreport and plots fit outputs
        if debug is True:
            print(result.fit_report())
            plt.plot(energy_axis_red[int(startelement):int(endelement)],Temperature_array[int(startelement):int(endelement)],'bo', label='best')
            plt.plot(x, result.init_fit, 'k--', label='initial fit')
            plt.plot(x, result.best_fit, 'r-', label='best fit')
            plt.legend(loc='best')
            #plt.savefig(save_directory_fitresults+"/Fit_at time="+time+"ns_on_"+file_name)
            plt.show()

        # Safe the fitting parameters. If the relative uncertainty of the lifetime is >100%, it is not saved as fit is useless
        try:
            if result.params['Te'].stderr >= abs(result.params['Te'].value):
                carriertemp = np.NaN
                carriertemp_uncer = np.NaN
                A1 = np.NaN
                A1_uncer = np.NaN
                init_energy = result.params['init_E'].value
                chemicalpotential = np.NaN
                chemicalpotential_uncer = np.NaN
            else:
                carriertemp = result.params['Te'].value
                carriertemp_uncer = result.params['Te'].stderr
                A1 = result.params['A'].value
                A1_uncer = result.params['A'].stderr
                init_energy = result.params['init_E'].value
    # If any strange error occurs then nothing is saved
        except:
            carriertemp = np.NaN
            carriertemp_uncer = np.NaN
            A1 = np.NaN
            A1_uncer = np.NaN
            init_energy = result.params['init_E'].value
            chemicalpotential = np.NaN
            chemicalpotential_uncer = np.NaN

        red_chi = result.redchi

# If 2 lifetime fit is ever implemented
        if Type_of_fit == 1:
            chemicalpotential = np.NaN
            chemicalpotential_uncer = np.NaN
        elif Type_of_fit == 2:
            chemicalpotential = result.params['mu'].value
            chemicalpotential_uncer = result.params['mu'].stderr
    #     channel2 = result.params['A2'].value
    #     channel2_uncer = result.params['A2'].stderr
# All parameters of the different wavelengths/energies are saved
        fit_results_array[k, 0] = time
        fit_results_array[k, 1] = carriertemp
        fit_results_array[k, 2] = carriertemp_uncer
        fit_results_array[k, 3] = A1
        fit_results_array[k, 4] = A1_uncer
        fit_results_array[k, 5] = init_energy
        fit_results_array[k, 6] = chemicalpotential
        fit_results_array[k, 7] = chemicalpotential_uncer
        fit_results_array[k, 8] = energy_axis_red[maxelement]
        fit_results_array[k, 9] = red_chi
    
    #if Type_of_fit is 2:
    #fit_results_N2_array[filenum - 1, 0] = chemicalpotential
    #fit_results_N2_array[filenum - 1, 1] = chemicalpotential_uncer


        time = fit_results_array[:, 0]
        carriertemp = fit_results_array[:, 1]
        carriertemp_error = fit_results_array[:, 2]
        A1 = fit_results_array[:, 3]
        A1_error = fit_results_array[:, 4]
        init_energy = fit_results_array[:, 5]
        chemicalpotential = fit_results_array[:, 6]
        chemicalpotential_uncer = fit_results_array[:, 7]
        PL_peak = fit_results_array[:, 8]
        chi_sqrs = fit_results_array[:, 9]

    return time, carriertemp, carriertemp_error, A1, A1_error, init_energy, chemicalpotential, chemicalpotential_uncer, PL_peak, chi_sqrs

#### LSW fit #####
def fit_LSWTefit_TRES(init_val, debug, map_spectrum_E_red, TimeAxis, E_red, Ttime_start, Ttime_end, average_initial_time, init_E_0_1, Eg_0_1,deltamu_0_1, Tc_0_1, A2_0_1, y0_0_1,w_0_1, maxintensitytime):
    TimeAxis = TimeAxis/1000  # converts ps time axis to ns
    # ns,  this is the time resolution used in measurement
    time_res = (TimeAxis[4] - TimeAxis[3]) #in ns --> Hebben we niet nodig nu
   # wave_res = (wavelength_axis_red[4]-wavelength_axis_red[3])
   # energy_res = (E_red[4]-E_red[3])
    
    # Select to the times wanted to fit Te to
    Ttime_start_real=average_initial_time+Ttime_start
    Ttime_end_real=average_initial_time+Ttime_end
    start_element_time = time_to_element(Ttime_start_real, time_res)
    start_element_time = start_element_time.astype(int)
    end_element_time = time_to_element(Ttime_end_real, time_res)
    end_element_time = end_element_time.astype(int)
    #start_element_time = findNearestSorted(TimeAxis,Ttime_start_real)
    #end_element_time = findNearestSorted(TimeAxis,Ttime_end_real)
    

    map_spectrum_E_red_T=np.transpose(map_spectrum_E_red)                                     
    # map_spectrum_W_red with only the times of interest by deleting all other columns
    map_spectrum_E_red_red = map_spectrum_E_red_T[start_element_time:end_element_time, :]
    # reduced time axis
    TimeAxis_red = TimeAxis[start_element_time:end_element_time]
    numbertime = len(TimeAxis_red)                                     
    
    # Reverse energy axis to make it going from down to up
    # E_red=np.flip(E_red)

    fit_results_array = np.full([numbertime, 15], None)
    
    #Iteration of fits, to distinguish first fit from later ones
    fit_iteration = 0
    
    # will select each row to do the temperature fit on
    for k in range(map_spectrum_E_red_red.shape[0]):
        # extract temperature for each time
        Temperature_array = map_spectrum_E_red_red[k, :]
        #Temperature_array = np.flip(Temperature_array)
        time = TimeAxis_red[k]-maxintensitytime/1000
        time_title=str(time)+'ns'


        # start fit by finding 80% of maximum point and fit from there till end of the spectrum

        # region of interest for max
        max_energy_1 = Tenergy_start - 0.2  # eV (to account for red shift at positive times)
        #max_wavelength_1 = 1239.8/Tenergy_start  # nm
        #max_element_1 = max_wavelength_1 / wave_res
        #max_element_1 = max_energy_1 / energy_res - (max(E_red)/energy_res)
        max_element_1 = findNearest(E_red, max_energy_1)
        max_energy_2 = Tenergy_start + 0.15 # eV (to account for blue shift at negative times)
       #max_wavelength_2 = 1239.8/max_energy_2  # nm
       #max_element_2 = max_wavelength_2 / wave_res
        max_element_2 = findNearest(E_red, max_energy_2)
        endenergy = Tenergy_end  # eV
        endelement = findNearest(E_red, endenergy)

        if debug is True:
            print(max_element_1)
            print(max_element_2)
            print(endelement)
    
        
        # define x and y data
        # define start and end element of temperature fit 
        maxvalue = np.max(Temperature_array[int(round(max_element_1)):int(round(max_element_2))])
        maxelement = findNearest(Temperature_array, maxvalue)
        startvalue = 0.90*maxvalue
        
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        startelement = findNearest(Temperature_array[1:int(round(maxelement))], startvalue)
        #startelement = maxelement+findNearest(Temperature_array[int(round(maxelement)):int(round(endelement))], startvalue)
        #startelement = findNearest(Temperature_array, startvalue)
        if debug is True:
            print("start checking max from "+str(max_element_1))
            print("start element with max is"+str(startelement))
            print("Which is energy" + str(findNearest(E_red, startelement)))
            print("with value"+str(maxvalue))

        # Check whether the data range is correct:
        # if debug is True:
        #     plt.plot(E_red[int(startelement):int(endelement)],Temperature_array[int(startelement):int(endelement)],'bo', label='data')
        #     plt.legend(loc='best')
        #     plt.title(time_title, fontweight ='bold')
        #     plt.show()        
        

        #start_energy = E_red[startelement]
        
        #start_energy = Temperature_array[startelement]
    # how many eV long the fit should be
    

 # Create axis
        x = E_red[int(startelement):int(endelement)] #Let op, omgedraaid ten opzichte van lifetimefit
        y = Temperature_array[int(startelement):int(endelement)] #Let op, omgedraaid ten opzichte van lifetimefit
 
 # # Define initial values for the fit
 #        start_energy = 0       
 #        init_E_0_1 = start_energy #start energy
 #        Eg_0_1 = 0.65  # initial carrier temperature (K)
 #        deltamu_0_1 = 0.67  # initial amplitude decay 1
 #        Tc_0_1 = 269
 #        A2_0_1 = -21 #9E-24
 #        y0_0_1 = 0   
 
 # Loop over fit iterations
        Decay_model = Model(LSW) 
        # if fit_iteration == 0 :     
        #     init_E_0 = init_E_0_1 #start energy
        #     Eg_0 = Eg_0_1  # initial carrier temperature (K)
        #     deltamu_0 = deltamu_0_1  # initial amplitude decay 1
        #     Tc_0 = Tc_0_1
        #     A2_0 = A2_0_1 #9E-24
        #     y0_0 = y0_0_1

        # #every next fit uses the fitting parameters of the last fit as their initial conditions (to improve consistency of the fit) however if last fit failed the base starting values are used again
        # else:
        #     if ((np.isnan(init_energy[fit_iteration-1]) is False) and (init_energy[fit_iteration-1] !=0)):
        #         init_E_0 = init_energy[fit_iteration-1]  # start energy
        #     else:
        #         init_E_0 = start_energy


        #     # print(Bandgapenergy[fit_iteration-1])
        #     if np.isnan(Bandgapenergy[fit_iteration-1]) is True:
        #         Eg_0 = Eg_0_1  # initial carrier temperature (K)
        #     else:
        #         Eg_0 = Bandgapenergy[fit_iteration-1]
        #          #Eg_0 = Bandgapenergy[fit_iteration-1]-4E-5 #Possible if we want to account for the red-shift of the bandgapenergy with time

        #     # print("Eg_0 is" + str(Eg_0))

        #     if np.isnan(deltafermi[fit_iteration-1]) is True:
        #         deltamu_0 = deltamu_0_1  # initial amplitude decay 1
        #     else:
        #         deltamu_0 = deltafermi[fit_iteration-1]
        #             #deltamu_0 = deltafermi[fit_iteration-1]-5E-5 #Possible if we want to account for the red-shift of the quasifermilevel with time

        #     # print("deltamu_0 is" + str(deltamu_0))

        #     if np.isnan(Carriertemp[fit_iteration-1]) is True:
        #         Tc_0 = Tc_0_1
        #     else:
        #         Tc_0 = Carriertemp[fit_iteration-1]

        #     if np.isnan(A[fit_iteration-1]) is True:
        #         A2_0 = A2_0_1  # 9E-24
        #     else:
        #         A2_0 = A[fit_iteration-1]

        #     if np.isnan(Finalintenisty[fit_iteration-1]) is True:
        #         y0_0 = y0_0_1
        #     else:
        #         y0_0 = Finalintenisty[fit_iteration-1]  
                
        if init_val is True:
            if fit_iteration == 0 :     
                init_E_0 = init_E_0_1 #start energy
                Eg_0 = Eg_0_1  # initial carrier temperature (K)
                deltamu_0 = deltamu_0_1  # initial amplitude decay 1
                Tc_0 = Tc_0_1
                A2_0 = A2_0_1 #9E-24
                y0_0 = y0_0_1
                w_0 = w_0_1

        #every next fit uses the fitting parameters of the last fit as their initial conditions (to improve consistency of the fit) however if last fit failed the base starting values are used again
            else:
                if ((np.isnan(init_energy[fit_iteration-1]) is False) and (init_energy[fit_iteration-1] !=0)):
                    init_E_0 = init_energy[fit_iteration-1]  # start energy
                else:
                    init_E_0 = start_energy


            # print(Bandgapenergy[fit_iteration-1])
                if np.isnan(Bandgapenergy[fit_iteration-1]) is True:
                    Eg_0 = Eg_0_1  # initial carrier temperature (K)
                else:
                    Eg_0 = Bandgapenergy[fit_iteration-1]
                    #Eg_0 = Bandgapenergy[fit_iteration-1]-4E-5 #Possible if we want to account for the red-shift of the bandgapenergy with time

            # print("Eg_0 is" + str(Eg_0))

                if np.isnan(deltafermi[fit_iteration-1]) is True:
                    deltamu_0 = deltamu_0_1  # initial amplitude decay 1
                else:
                    deltamu_0 = deltafermi[fit_iteration-1]
                    #deltamu_0 = deltafermi[fit_iteration-1]-5E-5 #Possible if we want to account for the red-shift of the quasifermilevel with time

            # print("deltamu_0 is" + str(deltamu_0))

                if np.isnan(Carriertemp[fit_iteration-1]) is True:
                    Tc_0 = Tc_0_1
                else:
                    Tc_0 = Carriertemp[fit_iteration-1]

                if np.isnan(A[fit_iteration-1]) is True:
                    A2_0 = A2_0_1  # 9E-24
                else:
                    A2_0 = A[fit_iteration-1]

                if np.isnan(Finalintenisty[fit_iteration-1]) is True:
                    y0_0 = y0_0_1
                else:
                    y0_0 = Finalintenisty[fit_iteration-1]

                if np.isnan(Broadening[fit_iteration-1]) is True:
                    w_0 = w_0_1
                else:
                    w_0 = Broadening[fit_iteration-1]

        if init_val is False:        
            if fit_iteration >= 0 : 
                init_E_0 = init_E_0_1 #start energy
                Eg_0 = Eg_0_1  # initial carrier temperature (K)
                deltamu_0 = deltamu_0_1  # initial amplitude decay 1
                Tc_0 = Tc_0_1
                A2_0 = A2_0_1 #9E-24
                y0_0 = y0_0_1
                w_0 = w_0_1
        
        #every next fit uses the fitting parameters of the last fit as their initial conditions (to improve consistency of the fit) however if last fit failed the base starting values are used again
            else:
                if ((np.isnan(init_energy[fit_iteration-1]) is False) and (init_energy[fit_iteration-1] !=0)):
                    init_E_0 = init_energy[fit_iteration-1]  # start energy
                else:
                    init_E_0 = start_energy


            # print(Bandgapenergy[fit_iteration-1])
                if np.isnan(Bandgapenergy[fit_iteration-1]) is True:
                    Eg_0 = Eg_0_1  # initial carrier temperature (K)
                else:
                    Eg_0 = Bandgapenergy[fit_iteration-1]
                    #Eg_0 = Bandgapenergy[fit_iteration-1]-4E-5 #Possible if we want to account for the red-shift of the bandgapenergy with time

            # print("Eg_0 is" + str(Eg_0))

                if np.isnan(deltafermi[fit_iteration-1]) is True:
                    deltamu_0 = deltamu_0_1  # initial amplitude decay 1
                else:
                    deltamu_0 = deltafermi[fit_iteration-1]
                    #deltamu_0 = deltafermi[fit_iteration-1]-5E-5 #Possible if we want to account for the red-shift of the quasifermilevel with time

            # print("deltamu_0 is" + str(deltamu_0))

                if np.isnan(Carriertemp[fit_iteration-1]) is True:
                    Tc_0 = Tc_0_1
                else:
                    Tc_0 = Carriertemp[fit_iteration-1]

                if np.isnan(A[fit_iteration-1]) is True:
                    A2_0 = A2_0_1  # 9E-24
                else:
                    A2_0 = A[fit_iteration-1]

                if np.isnan(Finalintenisty[fit_iteration-1]) is True:
                    y0_0 = y0_0_1
                else:
                    y0_0 = Finalintenisty[fit_iteration-1]
                
        result = Decay_model.fit(y, E=x, 
                init_E=Parameter('initial energy (eV)', value=init_E_0, vary=False),
                Eg=Parameter('Eg (eV)', value=Eg_0, min=0.4, max=1.0,vary=True),
                deltamu=Parameter('deltamu (eV)', value=deltamu_0, min=0.2, max=1.0, vary=True),
                Tc=Parameter('Carrier temperature (K)', value=Tc_0, min=1.0, max=2000.0),
                A2=Parameter('Scaling factor', value=A2_0, min=-30, max=-10),
                y0=Parameter('Final intenisty (a.u.)', value=y0_0,  min=-40, max=40,vary=True),
                w=Parameter('Broadening Factor (eV)', value = w_0, min = 0.001, max = 1,vary=True),max_nfev=400)
        
    #    y_pos=str(np.max(Temperature_array[int(startelement):int(endelement)])/2)
        
        temperature_title= 'Tc:'+ str(result.params['Tc'].value)+'K +/-'+str(result.params['Tc'].stderr) +'K'
        title='t:'+time_title+', '+temperature_title
        
        if debug is True:
            print(result.fit_report())
            plt.plot(E_red[int(startelement):int(endelement)],Temperature_array[int(startelement):int(endelement)],'bo', label='data')
            plt.plot(x, result.init_fit, 'k--', label='initial fit')
            plt.plot(x, result.best_fit, 'r-', label='best fit')
            plt.xlabel('Energy (eV)')
            plt.ylabel('Intensity (a.u.)')
            plt.legend(loc='best')
            #plt.text(0.5,0.5,temperature_title,fontsize=12)
            plt.title(title, fontweight ='bold')
     #       plt.text(0.9,y_pos,'Tc='+ result.params['Tc'].value, fontsize=15)
            #plt.savefig(file_directory+save_directory_metadata+"/Fit_LSW_"+str(time)+"ns.png")
            plt.savefig(save_directory_metadata+"/Fit_LSW_"+str(time)+"ns.png")
            plt.show()
            
        if debug is False:
             #print(result.fit_report())
             plt.plot(E_red[int(startelement):int(endelement)],Temperature_array[int(startelement):int(endelement)],'bo', label='data')
             plt.plot(x, result.init_fit, 'k--', label='initial fit')
             plt.plot(x, result.best_fit, 'r-', label='best fit')
             plt.xlabel('Energy (eV)')
             plt.ylabel('Intensity (a.u.)')
             plt.legend(loc='best')
             #plt.text(0.5,0.5,temperature_title,fontsize=12)
             plt.title(title, fontweight ='bold')
      #       plt.text(0.9,y_pos,'Tc='+ result.params['Tc'].value, fontsize=15)
             #plt.savefig(file_directory+save_directory_metadata+"/Fit_LSW_"+str(time)+"ns.png")
             plt.savefig(save_directory_metadata+"/Fit_LSW_"+str(time)+"ns.png")

             Spectrum_Fit_df=pd.DataFrame()
             Spectrum_Fit_df2 = pd.DataFrame()
             Spectrum_Fit_df["Energy Measurement (eV)"] = E_red
             Spectrum_Fit_df["Measured Intensity (a.u.)"] = Temperature_array
             Spectrum_Fit_df2['Energy (eV)'] = x
             Spectrum_Fit_df2["Fit result (a.u.)"] = result.best_fit

             Spectrum_Fit_df.to_csv(save_directory_metadata+"/Spectrum_LSW_"+str(time)+"ns.csv", index=False)
             Spectrum_Fit_df2.to_csv(save_directory_metadata +"/Fit_LSW_" + str(time) + "ns.csv", index=False)

             #plt.show()  
             plt.clf()

   # If debug is on, print fitreport and plots fit outputs

 #   Safe the fitting parameters. If the relative uncertainty of the lifetime is >100%, it is not saved as fit is useless
        try:
            if fit_iteration < 0:#result.params['Tc'].stderr >= abs(result.params['Tc'].value):
                Bandgapenergy = np.NaN
                Bandgapenergy_uncer = np.NaN
                deltafermi = np.NaN
                deltafermi_uncer = np.NaN
                Carriertemp = np.NaN
                Carriertemp_uncer = np.NaN
                A = np.NaN
                A_uncer = np.NaN
                init_energy = result.params['init_E'].value
                y0 = np.NaN
                y0_uncer = np.NaN
                w = np.NaN
                w_uncer = np.NaN

            else:
                Bandgapenergy = result.params['Eg'].value
                Bandgapenergy_uncer = result.params['Eg'].stderr
                deltafermi = result.params['deltamu'].value
                deltafermi_uncer = result.params['deltamu'].stderr
                Carriertemp = result.params['Tc'].value
                Carriertemp_uncer = result.params['Tc'].stderr
                A = result.params['A2'].value
                A_uncer = result.params['A2'].stderr
                init_energy = result.params['init_E'].value
                y0 = result.params['y0'].value
                y0_uncer = result.params['y0'].stderr
                w = result.params['w'].value
                w_uncer = result.params['w'].stderr
    #If any strange error occurs then nothing is saved
        except:
                Bandgapenergy = np.NaN
                Bandgapenergy_uncer = np.NaN
                deltafermi = np.NaN
                deltafermi_uncer = np.NaN
                Carriertemp = np.NaN
                Carriertemp_uncer = np.NaN
                A = np.NaN
                A_uncer = np.NaN
                init_energy = result.params['init_E'].value
                y0 = np.NaN
                y0_uncer = np.NaN
                w = np.NaN
                w_uncer = np.NaN

        # Bandgapenergy = result.params['Eg'].value
        # Bandgapenergy_uncer = result.params['Eg'].stderr
        # deltafermi = result.params['deltamu'].value
        # deltafermi_uncer = result.params['deltamu'].stderr
        # Carriertemp = result.params['Tc'].value
        # Carriertemp_uncer = result.params['Tc'].stderr
        # A = result.params['A2'].value
        # A_uncer = result.params['A2'].stderr
        # init_energy = result.params['init_E'].value   
        # y0 = result.params['y0'].value
        # y0_uncer = result.params['y0'].stderr
        chisquart = result.chisqr

# All parameters of the different wavelengths/energies are saved
        fit_results_array[k, 0] = time
        fit_results_array[k, 1] = Bandgapenergy
        fit_results_array[k, 2] = Bandgapenergy_uncer
        fit_results_array[k, 3] = deltafermi
        fit_results_array[k, 4] = deltafermi_uncer
        fit_results_array[k, 5] = Carriertemp
        fit_results_array[k, 6] = Carriertemp_uncer
        fit_results_array[k, 7] = A
        fit_results_array[k, 8] = A_uncer
        fit_results_array[k, 9] = y0
        fit_results_array[k, 10] = y0_uncer
        fit_results_array[k, 11] = init_energy
        fit_results_array[k, 12] = chisquart
        fit_results_array[k, 13] = w
        fit_results_array[k, 14] = w_uncer
    
    #if Type_of_fit is 2:
    #fit_results_N2_array[filenum - 1, 0] = chemicalpotential
    #fit_results_N2_array[filenum - 1, 1] = chemicalpotential_uncer

        time = fit_results_array[:, 0]
        Bandgapenergy = fit_results_array[:, 1]
        Bandgapenergy_uncer = fit_results_array[:, 2]
        deltafermi = fit_results_array[:, 3]
        deltafermi_uncer = fit_results_array[:, 4]
        Carriertemp = fit_results_array[:, 5]
        Carriertemp_uncer = fit_results_array[:, 6]
        A = fit_results_array[:, 7]
        A_uncer = fit_results_array[:, 8]
        Finalintenisty = fit_results_array[:, 9]
        Finalintenisty_uncer = fit_results_array[:, 10]
        init_energy = fit_results_array[:, 11]
        chisquart = fit_results_array[:, 12]
        Broadening = fit_results_array[:, 13]
        Broadening_error = fit_results_array[:, 14]

        Bandgapenergy=pd.Series(np.float64(Bandgapenergy)).interpolate().values
        Bandgapenergy_uncer=pd.Series(np.float64(Bandgapenergy_uncer)).interpolate().values
        deltafermi=pd.Series(np.float64(deltafermi)).interpolate().values
        deltafermi_uncer=pd.Series(np.float64(deltafermi_uncer)).interpolate().values
        Carriertemp=pd.Series(np.float64(Carriertemp)).interpolate().values
        Carriertemp_uncer=pd.Series(np.float64(Carriertemp_uncer)).interpolate().values
        A=pd.Series(np.float64(A)).interpolate().values
        A_uncer=pd.Series(np.float64(A_uncer)).interpolate().values
        Finalintenisty=pd.Series(np.float64(Finalintenisty)).interpolate().values
        Finalintenisty_uncer=pd.Series(np.float64(Finalintenisty_uncer)).interpolate().values
        Broadening = pd.Series(np.float64(Broadening)).interpolate().values
        Broadening_error = pd.Series(np.float64(Broadening_error)).interpolate().values

        fit_iteration += 1
        print(fit_iteration)
       
    return time, Bandgapenergy, Bandgapenergy_uncer, deltafermi, deltafermi_uncer, Carriertemp, Carriertemp_uncer, A, A_uncer, Finalintenisty, Finalintenisty_uncer, init_energy, chisquart, Broadening, Broadening_error

#### Cooling curve fit ####
def odefit(t, to, C, ho):
    kb = 8.627e-5  # [eV/K]
    def FT_model(Tc, t):

        return -C*1/(3*kb)*(ho/to)*np.exp(-ho/(kb*Tc)) # has a - sign in front, need to look why this is needed
    Tc0 = Te_axis[0]
    Tcsol = odeint(FT_model, Tc0, t)
    return Tcsol[:,0]

###Lifetime fit###
def fit_lifetimes_TRES(N_decaychannels, debug, TRES_map, time_axis, energy_axis, time_start, time_end, energy_start, energy_end):
    time_axis = time_axis/1000  # converts ps time axis to ns
    # ns,  this is the time resolution used in measurement
    time_res = (time_axis[4] - time_axis[3]) #in ns

    # Select to the energys wanted to fit lifetime to
    start_element = findNearestSorted(energy_axis, energy_start)
    end_element = findNearestSorted(energy_axis, energy_end)

    # TRES_map with only the wavelengths of interest by deleting all other rows

    ShapeMap = TRES_map.shape
    NRows = ShapeMap[0]

    TRES_map_red = TRES_map[:end_element, :][start_element:, :]
    # reduced energy axis
    energy_axis_red = energy_axis[start_element:end_element]
    numberenergy = len(energy_axis_red)


    fit_results_array = np.full([numberenergy, 11], None)
    fit_iteration = 0
        
    # will select each row to do the time decay fit on
    for k in range(TRES_map_red.shape[0]):
        # extract decay for each energy
        Timedecay_array = TRES_map_red[k, :]
        energy = energy_axis_red[k]
        energy_title=str(energy)+'eV'
        # start fit by finding maximum intensity point and fit from there till 2nd later

        # region of interest for max
        max_time_1 = time_start  # ns
        max_element_1 = max_time_1 / time_res
        max_time_2 = time_start + 3  # ns
        max_element_2 = max_time_2 / time_res

        if debug is True:
            print(max_element_1)
            print(max_element_2)

        # define x and y data
        # define start and end element of lifetime fit
        maxelement = np.argmax(Timedecay_array[int(round(max_element_1)):int(round(max_element_2))])+max_element_1
        maxvalue = np.max(Timedecay_array[int(round(max_element_1)):int(round(max_element_2))])
        startvalue = 1*maxvalue
        
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        #Temperature_array_interest=Temperature_array[int(round(maxelement)):int(round(endelement))]
        startelement = maxelement+findNearest(Timedecay_array[int(round(maxelement)):int(round(end_element))], startvalue)
        #startelement = findNearest(Temperature_array, startvalue)
        
        if debug is True:
            print("start checking max from"+str(max_element_1))
            print("start element with max is"+str(startelement))
            print("Which is time" + str(startelement*time_res))
            print("with value"+str(maxvalue))

        start_time = startelement * time_res

        # how many ns long the fit should be
        endtime = time_end  # ns
        endelement = startelement + time_to_element(endtime, time_res)

        # Create axis
        x = time_axis[int(startelement):int(endelement)]
        y = Timedecay_array[int(startelement):int(endelement)]


        init_t_0 = start_time+0 #Extra delay na piek
        y0_0 = 0 
        tau1_0_1 = 0.2  # initial short lifetime in ns
        A1_0_1 = 309
        A2_0_1 = 68
        
        if fit_iteration == 0 :     
        #if fit_iteration >= 0 : 
            tau1_0 = tau1_0_1  # initial short lifetime in ns
            A1_0 = A1_0_1  # initial amplitude decay 1
                    
        #every next fit uses the fitting parameters of the last fit as their initial conditions (to improve consistency of the fit) however if last fit failed the base starting values are used again
        else:
            if np.isnan(lifetimes[fit_iteration-1]) is True:
                tau1_0 = tau1_0_1  # initial short lifetime in ns
            else:
                tau1_0 = lifetimes[fit_iteration-1]


            if np.isnan(channelstrengths[fit_iteration-1]) is True:
                A1_0 = A1_0_1  # initial amplitude decay 1
            else:
                A1_0 = channelstrengths[fit_iteration-1]
                #deltamu_0 = deltafermi[fit_iteration-1]-5E-5 #Possible if we want to account for the red-shift of the quasifermilevel with time

            
        if N_decaychannels == 2:
            if fit_iteration == 0 :     
                A2_0 = A2_0_1  # initial strength decay 2
            else:
                if np.isnan(channelstrengths_2[fit_iteration-1]) is True:
                    A2_0 = A2_0_1  # initial amplitude decay 1
                else:
                    A2_0 = channelstrengths_2[fit_iteration-1]

        # first guess initial values order (t, init_t, y0, A1, A2, tau1 , tau2)
        if N_decaychannels == 1:
            Decay_model = Model(monoexpdecay)
            result = Decay_model.fit(y, t=x, init_t=Parameter('initial time (ns)', value=init_t_0, vary=False),
                                     y0=Parameter('Baseline', value=y0_0, vary=False),
                                     A1=Parameter('A1', value=A1_0, min=0.01),
                                     tau1=Parameter('short lifetime (ns)', value=tau1_0, min=0.01))
        elif N_decaychannels == 2:
            Decay_model = Model(biexpdecay)
            result = Decay_model.fit(y, t=x, init_t=Parameter('initial time (ns)', value=init_t_0, vary=False),
                                     y0=Parameter('Baseline', value=y0_0, vary=False, min=-500),
                                     A1=Parameter('A1', value=A1_0, min=0.01),
                                     A2=Parameter('A2', value=A2_0, min=0),
                                     tau1=Parameter('short lifetime (ns)', value=tau1_0, min=0.01),
                                     Deltatau=Parameter('Deltatau', value=1, min=0),
                                     tau2=Parameter('tail lifetime (ns)', expr='tau1+Deltatau'))

        # If debug is on, print fitreport and plots fit outputs
        if debug is True:
            print(result.fit_report())
           # fig, ax = plt.subplots(figsize=(12, 8))
            # plt.plot(time_axis[int(startelement):int(endelement)],
            #          Timedecay_array[int(startelement):int(endelement)], 'bo')
            plt.plot(time_axis[int(startelement - 20):int(endelement)+500],
                      Timedecay_array[int(startelement - 20):int(endelement)+500], 'bo')
            plt.plot(x, result.init_fit, 'k--', label='initial fit')
            plt.plot(x, result.best_fit, 'r-', label='best fit')
            plt.legend(loc='best')
            plt.title(energy_title, fontweight ='bold')
            plt.yscale("log")
            plt.savefig(save_directory_metadata+"/Fit_lifetime_"+str(energy)+"eV.png")
            plt.show()
            
        if debug is False:
            plt.plot(time_axis[int(startelement - 20):int(endelement)+500],
                      Timedecay_array[int(startelement - 20):int(endelement)+500], 'bo')
            plt.plot(x, result.init_fit, 'k--', label='initial fit')
            plt.plot(x, result.best_fit, 'r-', label='best fit')
            plt.legend(loc='best')
            plt.title(energy_title, fontweight ='bold')
            plt.yscale("log")
            plt.savefig(save_directory_metadata+"/Fit_lifetime_"+str(energy)+"eV.png")
            #plt.show()  
            plt.clf()            

        # Safe the fitting parameters. If the relative uncertainty of the life_ is >100%, it is not saved as fit is useless
        # try:
        #     if result.params['tau1'].stderr >= abs(result.params['tau1'].value):
        #         lifetime = np.NaN
        #         lifetime_uncer = np.NaN
        #         channel1 = np.NaN
        #         channel1_uncer = np.NaN
        #         init_time = result.params['init_t'].value
        #     else:
        #         lifetime = result.params['tau1'].value
        #         lifetime_uncer = result.params['tau1'].stderr
        #         channel1 = result.params['A1'].value
        #         channel1_uncer = result.params['A1'].stderr
        #         init_time = result.params['init_t'].value
        # # If any strange error occurs then nothing is saved
        # except:
        #     lifetime = np.NaN
        #     lifetime_uncer = np.NaN
        #     channel1 = np.NaN
        #     channel1_uncer = np.NaN
        #     init_time = result.params['init_t'].value

        lifetime = result.params['tau1'].value
        lifetime_uncer = result.params['tau1'].stderr
        channel1 = result.params['A1'].value
        channel1_uncer = result.params['A1'].stderr
        init_time = result.params['init_t'].value
        chisqr = result.chisqr

    # If 2 lifetime fit is ever implemented
        if N_decaychannels == 2:
            lifetime_2 = result.params['tau2'].value
            lifetime_2_uncer = result.params['tau2'].stderr
            channel2 = result.params['A2'].value
            channel2_uncer = result.params['A2'].stderr
        
    # All parameters of the different energys/energies are saved
        fit_results_array[k, 0] = energy
        fit_results_array[k, 1] = lifetime
        fit_results_array[k, 2] = lifetime_uncer
        fit_results_array[k, 3] = channel1
        fit_results_array[k, 4] = channel1_uncer
        fit_results_array[k, 5] = init_time
        fit_results_array[k, 6] = chisqr
        
        if N_decaychannels == 1:
            fit_results_array[k, 7] = np.NaN
            fit_results_array[k, 8] = np.NaN
            fit_results_array[k, 9] = np.NaN
            fit_results_array[k, 10] = np.NaN
        
        elif N_decaychannels == 2:
            fit_results_array[k, 7] = lifetime_2
            fit_results_array[k, 8] = lifetime_2_uncer
            fit_results_array[k, 9] = channel2
            fit_results_array[k, 10] = channel2_uncer
            
    
        energy = fit_results_array[:, 0]
        lifetimes = fit_results_array[:, 1]
        lifetimes_error = fit_results_array[:, 2]
        channelstrengths = fit_results_array[:, 3]
        channelstrengths_error = fit_results_array[:, 4]
        init_times = fit_results_array[:, 5]
        chi_sqrs = fit_results_array[:, 6]
        lifetimes_2 = fit_results_array[:, 7]
        lifetimes_error_2 = fit_results_array[:, 8]
        channelstrengths_2 = fit_results_array[:, 9]
        channelstrengths_error_2 = fit_results_array[:, 10]
    
        # lifetimes=pd.Series(np.float64(lifetimes)).interpolate().values
        # lifetimes_error=pd.Series(np.float64(lifetimes_error)).interpolate().values
        # channelstrengths=pd.Series(np.float64(channelstrengths)).interpolate().values
        # channelstrengths_error=pd.Series(np.float64(channelstrengths_error)).interpolate().values
        # init_times=pd.Series(np.float64(init_times)).interpolate().values
        # chi_sqrs=pd.Series(np.float64(chi_sqrs)).interpolate().values
        # lifetimes_2=pd.Series(np.float64(lifetimes_2)).interpolate().values
        # lifetimes_error_2=pd.Series(np.float64(lifetimes_error_2)).interpolate().values
        # channelstrengths_2=pd.Series(np.float64(channelstrengths_2)).interpolate().values
        # channelstrengths_error_2=pd.Series(np.float64(channelstrengths_error_2)).interpolate().values
        
        fit_iteration += 1
        print(fit_iteration)

    return energy, lifetimes, lifetimes_error, channelstrengths, channelstrengths_error, init_times, chi_sqrs, lifetimes_2, lifetimes_error_2, channelstrengths_2, channelstrengths_error_2


def fit_LSWTefit_v2_TRES(map_spectrum_E_red, TimeAxis, E_red, Ttime_start, Ttime_end, average_initial_time):
    debug = False
    TimeAxis = TimeAxis / 1000  # converts ps time axis to ns
    time_res = (TimeAxis[4] - TimeAxis[3])  # in ns --> Hebben we niet nodig nu

    # Select to the times wanted to fit Te to
    Ttime_start_real = average_initial_time + Ttime_start
    Ttime_end_real = average_initial_time + Ttime_end
    start_element_time = time_to_element(Ttime_start_real, time_res)
    start_element_time = start_element_time.astype(int)
    end_element_time = time_to_element(Ttime_end_real, time_res)
    end_element_time = end_element_time.astype(int)

    map_spectrum_E_red_T = np.transpose(map_spectrum_E_red)
    # map_spectrum_W_red with only the times of interest by deleting all other columns
    map_spectrum_E_red_red = map_spectrum_E_red_T[start_element_time:end_element_time, :]
    # reduced time axis
    TimeAxis_red = TimeAxis[start_element_time:end_element_time]
    numbertime = len(TimeAxis_red)

    # Reverse energy axis to make it going from down to up
    # E_red=np.flip(E_red)

    # fit_results_array = np.full([numbertime, 13], None)
    fit_results_array = np.full([numbertime, 13], None)

    # will select each row to do the temperature fit on
    for k in range(map_spectrum_E_red_red.shape[0]):
        # extract temperature for each time
        Temperature_array = map_spectrum_E_red_red[k, :]
        Temperature_array = np.flip(Temperature_array)
        time = TimeAxis_red[k] - maxintensitytime / 1000
        time_title = str(time) + 'ns'

        # Temperature_array = map_spectrum_W_red_red[35, :]
        # Temperature_array = np.flip(Temperature_array)
        # time = time_axis_red[35]
        # time_title=str(time)+'ns'

        # region of interest for max
        max_energy_1 = Tenergy_start - 0.2  # eV (to account for red shift at positive times)
        # max_wavelength_1 = 1239.8/Tenergy_start  # nm
        # max_element_1 = max_wavelength_1 / wave_res
        # max_element_1 = max_energy_1 / energy_res - (max(energy_axis_red)/energy_res)
        max_element_1 = findNearest(E_red, max_energy_1)
        max_energy_2 = Tenergy_start + 0.15  # eV (to account for blue shift at negative times)
        # max_wavelength_2 = 1239.8/max_energy_2  # nm
        # max_element_2 = max_wavelength_2 / wave_res
        max_element_2 = findNearest(E_red, max_energy_2)
        endenergy = Tenergy_end  # eV
        endelement = findNearest(E_red, endenergy)

        if debug is True:
            print(max_element_1)
            print(max_element_2)
            print(endelement)

        # define x and y data
        # define start and end element of temperature fit
        maxvalue = np.max(Temperature_array[int(round(max_element_1)):int(round(max_element_2))])
        maxelement = findNearest(Temperature_array, maxvalue)
        startvalue = 0.9 * maxvalue

        # startelement = findNearest(Temperature_array[1:int(round(maxelement))], startvalue)
        startelement = maxelement + findNearest(Temperature_array[int(round(maxelement)):int(round(endelement))],
                                                startvalue)  # start element on 90% after peak

        x = E_red[int(startelement):int(endelement)]  # Let op, omgedraaid ten opzichte van lifetimefit
        y = Temperature_array[int(startelement):int(endelement)]  # Let op, omgedraaid ten opzichte van lifetimefit

        # %Create interpolated fit of dataset
        # y_spl = UnivariateSpline(x,y,s=100,k=3)

        # plt.plot(x,y,'ro',label = 'data')
        # x_range = np.linspace(x[0],x[-1],1000)
        # plt.plot(x_range,y_spl(x_range))

        # %Get second derivative of interpolated fit
        # y_spl_2d = y_spl.derivative(n=2)
        # plt.plot(x_range,y_spl_2d(x_range))

        # %Get first derivative of interpolated fit
        # y_spl_1d = y_spl.derivative(n=1)
        # plt.plot(x_range,y_spl_1d(x_range))

        # %Try to fit it together
        y_spl = UnivariateSpline(x, y, s=300, k=3)
        y_spl_2d = y_spl.derivative(n=2)
        # y_spl_1d = y_spl.derivative(n=1)
        x_range = np.linspace(x[0], x[-1], 1000)

        fig, ax1 = plt.subplots()
        ax2 = ax1.twinx()
        ax1.plot(x_range, y_spl(x_range), 'g-')
        ax2.plot(x_range, y_spl_2d(x_range), 'b-')

        ax1.set_xlabel('Energy (eV)')
        ax1.set_ylabel('Intensity', color='g')
        ax2.set_ylabel('2nd derivative of internsity', color='b')

        plt.show()

        for x_val in x_range:
            # Evaluate the second derivative at each x value
            second_derivative = y_spl_2d(x_val)

            # Check if the second derivative changes sign
            if second_derivative < 0:
                # The second derivative changes from negative to positive,
                # so this is the first point where it is zero
                endenergy2 = x_val
                break

        # Print the first x value where the second derivative is zero
        print("First x value where second derivative is zero:", endenergy2)

        endelement2 = findNearest(E_red, endenergy2)
        startelement = findNearest(Temperature_array[1:int(round(maxelement))], startvalue)

        x = E_red[int(startelement):int(endelement2)]  # Let op, omgedraaid ten opzichte van lifetimefit
        y = Temperature_array[int(startelement):int(endelement2)]  # Let op, omgedraaid ten opzichte van lifetimefit

        Decay_model = Model(LSW)
        init_E_0 = 0  # start energy
        Eg_0 = 0.66  # initial carrier temperature (K)
        deltamu_0 = 0.57  # initial amplitude decay 1
        Tc_0 = 300
        A2_0 = -22  # 9E-24
        y0_0 = 0

        # result = Decay_model.fit(y, E=x, init_E=Parameter('initial energy (eV)', value=init_E_0, vary=False),
        #         Eg=Parameter('Eg (eV)', value=Eg_0, min=0.6, max=0.7,vary=True),
        #         deltamu=Parameter('deltamu (eV)', value=deltamu_0, min=0.6, max=0.9),
        #         Tc=Parameter('Carrier temperature (K)', value=Tc_0, min=6, max=400),
        #         A2=Parameter('Scaling factor', value=A2_0, min=-30, max=-10),max_nfev=400)

        result = Decay_model.fit(y, E=x,
                                 init_E=Parameter('initial energy (eV)', value=init_E_0, vary=False),
                                 Eg=Parameter('Eg (eV)', value=Eg_0, min=0.3, max=1.0, vary=True),
                                 deltamu=Parameter('deltamu (eV)', value=deltamu_0, min=0.0, max=2.0),
                                 Tc=Parameter('Carrier temperature (K)', value=Tc_0, min=1.0, max=2000.0),
                                 A2=Parameter('Scaling factor', value=A2_0, min=-30, max=-10),
                                 y0=Parameter('Final intenisty (a.u.)', value=y0_0, min=-4, max=4, vary=False),
                                 max_nfev=400)

        Bandgapenergy = result.params['Eg'].value
        Bandgapenergy_uncer = result.params['Eg'].stderr
        deltafermi = result.params['deltamu'].value
        deltafermi_uncer = result.params['deltamu'].stderr
        Carriertemp = result.params['Tc'].value
        Carriertemp_uncer = result.params['Tc'].stderr
        A = result.params['A2'].value
        A_uncer = result.params['A2'].stderr
        init_energy = result.params['init_E'].value
        y0 = result.params['y0'].value
        y0_uncer = result.params['y0'].stderr
        chisquart = result.chisqr

        x_extended = E_red[int(startelement):int(endelement)]
        y_extended = Temperature_array[int(startelement):int(endelement)]
        result_extended = Decay_model.fit(y_extended, E=x_extended,
                                          init_E=Parameter('initial energy (eV)', value=init_energy, vary=False),
                                          Eg=Parameter('Eg (eV)', value=Bandgapenergy, min=0.5, max=1.0, vary=False),
                                          deltamu=Parameter('deltamu (eV)', value=deltafermi, min=0.0, max=2.0,
                                                            vary=False),
                                          Tc=Parameter('Carrier temperature (K)', value=Carriertemp, min=1.0,
                                                       max=2000.0, vary=False),
                                          A2=Parameter('Scaling factor', value=A, min=-30, max=-10, vary=False),
                                          y0=Parameter('Final intenisty (a.u.)', value=y0, min=-4, max=4, vary=False),
                                          max_nfev=400)

        if debug is True:
            print(result.fit_report())
            plt.plot(E_red[int(startelement):int(endelement)], Temperature_array[int(startelement):int(endelement)],
                     'bo', label='data')
            plt.plot(x, result.init_fit, 'k--', label='initial fit')
            plt.plot(x_extended, result_extended.best_fit, 'g-', label='best fit extended')
            plt.plot(x, result.best_fit, 'r-', label='best fit')
            plt.legend(loc='best')
            plt.title(time_title, fontweight='bold')
            plt.show()

        # All parameters of the different wavelengths/energies are saved
        fit_results_array[k, 0] = time
        fit_results_array[k, 1] = Bandgapenergy
        fit_results_array[k, 2] = Bandgapenergy_uncer
        fit_results_array[k, 3] = deltafermi
        fit_results_array[k, 4] = deltafermi_uncer
        fit_results_array[k, 5] = Carriertemp
        fit_results_array[k, 6] = Carriertemp_uncer
        fit_results_array[k, 7] = A
        fit_results_array[k, 8] = A_uncer
        fit_results_array[k, 9] = y0
        fit_results_array[k, 10] = y0_uncer
        fit_results_array[k, 11] = init_energy
        fit_results_array[k, 12] = chisquart

        time = fit_results_array[:, 0]
        Bandgapenergy = fit_results_array[:, 1]
        Bandgapenergy_uncer = fit_results_array[:, 2]
        deltafermi = fit_results_array[:, 3]
        deltafermi_uncer = fit_results_array[:, 4]
        Carriertemp = fit_results_array[:, 5]
        Carriertemp_uncer = fit_results_array[:, 6]
        A = fit_results_array[:, 7]
        A_uncer = fit_results_array[:, 8]
        Finalintenisty = fit_results_array[:, 9]
        Finalintenisty_uncer = fit_results_array[:, 10]
        init_energy = fit_results_array[:, 11]
        chisquart = fit_results_array[:, 12]

        Bandgapenergy = pd.Series(np.float64(Bandgapenergy)).interpolate().values
        Bandgapenergy_uncer = pd.Series(np.float64(Bandgapenergy_uncer)).interpolate().values
        deltafermi = pd.Series(np.float64(deltafermi)).interpolate().values
        deltafermi_uncer = pd.Series(np.float64(deltafermi_uncer)).interpolate().values
        Carriertemp = pd.Series(np.float64(Carriertemp)).interpolate().values
        Carriertemp_uncer = pd.Series(np.float64(Carriertemp_uncer)).interpolate().values
        A = pd.Series(np.float64(A)).interpolate().values
        A_uncer = pd.Series(np.float64(A_uncer)).interpolate().values
        Finalintenisty = pd.Series(np.float64(Finalintenisty)).interpolate().values
        Finalintenisty_uncer = pd.Series(np.float64(Finalintenisty_uncer)).interpolate().values

    return time, Bandgapenergy, Bandgapenergy_uncer, deltafermi, deltafermi_uncer, Carriertemp, Carriertemp_uncer, A, A_uncer, Finalintenisty, Finalintenisty_uncer, init_energy, chisquart

#%% Settings
#Whether you want to plot the interferogram
plot_if = False
#Choose zero_filling_factor (how much interpolation will be done in spectrum)
zero_filling_factor = 8
# Choose Apodization method
Apo_method="Blackman-Harris-3"
#Whether you are going to plot spectra or not
plot_prompt = False
#Whether you want to plot the FTIR map
plot_FTIRmap = False
#Whether you want to plot the initial times
plot_initTime = False


#%% Define data & Make folders to save results
current_directory = os.path.dirname(os.path.realpath(__file__))
#change this directory to where the data is safed (this will only work if only one set of TRPL_IF with axis is there)
file_directory="//PHYSSTOR/and\Hexagonal-SiGe\OPTICS_LAB\DATA_TRPL/2023-07-14 QW2046 longint 4K\Measurement/20230714/115822"
#os.chdir("W:/Hexagonal-SiGe/OPTICS_LAB/DATA_TRPL/2023-05-05 H07331 long integration/H07331/Measurement/20230505/115129/")
os.chdir(file_directory)

#Define the save directory folder names
save_directory_spectra="files_spectrum_v7"
save_directory_TRES="files_FTIR_maps_v7"
save_directory_metadata ="files_metadata_v7"
save_directory_fitresults="fit_results_v7"

#Make output folders in same folder as data
try: os.mkdir(save_directory_fitresults)
except: pass

try: os.mkdir(save_directory_TRES)
except: pass

try:  os.mkdir(save_directory_spectra)
except: pass

try:  os.mkdir(save_directory_metadata)
except: pass

#Find raw interferogram files
TRESfiles = glob.glob('*_MAP.txt')
TimeFiles = glob.glob('*_Time.txt')
PosFiles = glob.glob('*_POS.txt')

#checks whether only one file exists in folder
num_of_files = len(TRESfiles)
print(TRESfiles)
if num_of_files > 1:
    print("ERROR: More than 1 TRES map in folder, code will not work")
    #sys.exit(1)  # exiting with a non zero value is better for returning from an error

TRESfile = TRESfiles[0]
WaveFile = PosFiles[0]
TimeFile = TimeFiles[0]

#loadtxt will extract data from files
MAParray = np.loadtxt(TRESfile, dtype=float, delimiter=None)
PosAxis = np.loadtxt(WaveFile, dtype=float, delimiter=None)
TimeAxis = np.loadtxt(TimeFile, dtype=int, delimiter=None)

file_name = TRESfile.strip(".txt")

# Find intergration time
t = find_float(TRESfile, "t=")
t = float(t[0].strip("t="))

# Find Power
P = find_float(TRESfile, "P=")
P = float(P[0].strip("P="))
Power_title=str(P)+'uW'


# Find Temperature in filename
T = find_float(TRESfile, "T=")
T = float(T[0].strip("T="))

#%% Do python data maniplation from interferogram to spectrum
####start with removing all zeroes from end of data file returns reduced interferogram map and time axis####
MAParray, TimeAxis = cleaning_zeros(MAParray, TimeAxis)

####Check on total interferogram to check effect apodization#############
Interferogram = np.trapz(MAParray, TimeAxis, axis=1)
TimeDecay_IF = np.trapz(MAParray, PosAxis, axis=0)

if plot_if is True:
    plt.plot(PosAxis, Interferogram, label='IF')
    plt.title(file_name, fontweight ='bold')
    plt.legend()
    plt.show()
    
####background correction on IF####
if plot_if is True:
    mean_if_no_bg_correction =  np.sum(MAParray, axis=1)
    
MAParray = bg_correction(MAParray, method='linear', bi=True)

#### Get phase correction data, can also be saved/loaded to/from file
if plot_if is True:
    mean_if_no_phase_correction =  np.sum(MAParray, axis=1)
    
Phase_Correction_angle = get_phase_correction_angles(PosAxis, MAParray, zero_filling=zero_filling_factor, reduction=1)

if plot_if is True:
    mean_if_no_apo = np.sum(MAParray, axis=1)

# apodization correction, smoothening
interferogram_map, apodization = apodization_correction(PosAxis, MAParray, method = Apo_method)
print("apodization correction succeeded ")

if plot_if is True:
    mean_if = np.sum(interferogram_map, axis=1)
    x = np.linspace(0, len(mean_if), len(mean_if))
    plt.plot(x, mean_if_no_bg_correction, label="before Bg correction")
    #plt.plot(x, mean_if_no_phase_correction, label="no phase correction")
    plt.plot(x, mean_if_no_apo, label="before apodization")
    plt.plot(x, mean_if, label="final interferogram")
    plt.xlabel('Distance (a.u.)')
    plt.ylabel('Intensity (a.u.)')
    #plt.title(file_name, fontweight ='bold')
    plt.legend()
    plt.show()

#Preforming the FFT
E, map_spectrum_E, W, map_spectrum_W = get_calibrated_spectrum_map(PosAxis, interferogram_map, zero_filling_factor=zero_filling_factor, phase_corr_angle=Phase_Correction_angle)  # The Fourier transform on the interferogram
print("fft succeeded")

#%%### Do a dispersion correction ####
map_spectrum_E = dispersion_calibration_E(E, map_spectrum_E, TimeAxis)

#### Do an integration time correction ####
map_spectrum_E=np.divide(map_spectrum_E,t)

# Plotting the integrated spectrum and integrated time decay ####
Spectrum = np.sum(map_spectrum_E, axis=1)
if plot_prompt is True:
    plt.plot(E, Spectrum, label="Integrated spectrum BH")
    #plt.title(file_name, fontweight ='bold')
    plt.xlabel('Energy (eV)')
    plt.ylabel('Intensity (a.u.)')
    plt.xlim(0.55, 0.92)
    plt.legend()
    plt.show()
    
maxintenisity_spectrum=np.max(Spectrum)
maxintensity_spectrum_element=findNearest(Spectrum, maxintenisity_spectrum)
maxintensity_spectrum_energy=E[maxintensity_spectrum_element]

NormalizedSpectrum = Spectrum / np.max(Spectrum)

TimeDecay = np.sum(map_spectrum_E, axis=0)    
if plot_prompt is True:    
    plt.plot(TimeAxis, TimeDecay, label="Integrated time decay BH")
    #plt.title(file_name, fontweight ='bold')
    plt.xlabel('Time (ps)')
    plt.ylabel('Intensity (a.u.)')
    plt.xlim(0, 10000)
    plt.legend()
    plt.show()

maxintenisity=np.max(TimeDecay)
maxintensity_element=findNearest(TimeDecay, maxintenisity)
maxintensitytime=TimeAxis[maxintensity_element]

NormalizedTimeDecay = TimeDecay / np.max(TimeDecay)

TimeAxis_0=TimeAxis-maxintensitytime

####Save everything####    
Spectrum_results_df = pd.DataFrame()
Spectrum_results_df["Energy (eV)"] = E
Spectrum_results_df["Integrated intensity spectrum (a.u.)"]=Spectrum
Spectrum_results_df["Normalized integrated intensity spectrum (a.u.)"]=NormalizedSpectrum

Spectrum_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Spectrum_data.csv', index=False)


Decay_results_df = pd.DataFrame()
Decay_results_df["time (ps)"] = TimeAxis_0
Decay_results_df["time (ns)"] = TimeAxis_0/1000
Decay_results_df["Integrated intenisty time decay (a.u.)"] = TimeDecay
Decay_results_df["Normalized integrated intenisty time decay (a.u.)"] = NormalizedTimeDecay

Decay_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_decay_data.csv', index=False)
    
#%%## Set initial values for temperature fit

####Define start and end element where the Temp fits should happen ####
energy_start=0.55 #eV
energy_end=0.92 #eV

start_element_en = findNearestSorted(E, energy_start)
end_element_en = findNearestSorted(E, energy_end)

# reduced energy axis
E_red = E[start_element_en:end_element_en]

#### Define in which time period we want to investigate the initial times ####
time_start=0
time_end=time_start+3

#### Define from where the peak energy will be searched
Tenergy_start=maxintensity_spectrum_energy #eV of peak of integrated spectrum
Tenergy_end=np.max(E_red)

### TRES_map with only the energies of interest by deleting all other rows
ShapeMap = map_spectrum_E.shape
NRows = ShapeMap[0]

TRES_map_red = map_spectrum_E[:end_element_en, :][start_element_en:, :]
#print(np.shape(TRES_map_red), np.shape(map_spectrum_E))


#############################Plot TRPL-FTIR map ########################################
if plot_FTIRmap is True:
    fig, ax = plt.subplots(figsize=(12, 8))
    n_levels = 40
    z=TRES_map_red
    z = np.ma.masked_where(z <= 0, z)
    cs=ax.contourf(*np.meshgrid(TimeAxis_0/1e3, E_red), z, np.logspace(10E-3,np.log10(z.max()), n_levels), cmap=cm.jet, locator = ticker.LogLocator())
    ax.grid()
    ax.set_xlabel('Time (ns)', fontweight ='bold',fontsize=30)
    ax.set_ylabel('Energy (eV)', fontweight ='bold',fontsize=30)
    #ax.set_title('MQW MAP, 1.15 x 10^15 photons/cm^2s ', fontweight ='bold',fontsize=30)
    ax.set_ylim(0.55, 0.92)
    ax.set_xlim(-1, 9)
    ax.tick_params(axis='y', labelsize=20)
    ax.tick_params(axis='x', labelsize=20)
    cbar = fig.colorbar(cs)
    cbar.set_label('Counts (a.u)',fontsize=20)
    cbar.set_ticks(cbar.locator.tick_values(10E-2, z.max()))
    cbar.ax.tick_params(labelsize=20)
    plt.savefig(save_directory_metadata+"/MAP_")
    plt.show()
# # # #%%

#####change time resolution ####
number_of_averaging = 5
tres, map_spectrum_E_red = average_time_bins(TRES_map_red, E_red, TimeAxis, number_of_averaging)
file_name=file_name + tres + 'ps'

######################################Find initial times ####################################
# init_time = find_initial_time(map_spectrum_E_red, TimeAxis, time_start, time_end)
# if plot_initTime is True:
#     plt.plot(E_red, init_time, label="Initial times")
#     plt.title(file_name, fontweight ='bold')
#     plt.xlabel('Energy (eV)')
#     plt.ylabel('Initial time (ns)')
#     plt.legend()
#     plt.show()

#average_initial_time=np.nanmean(init_time) 
average_initial_time=maxintensitytime/1000
#%% Do plot of spectra at different times
negative_time=0 #-0.16 ns
positive_time=2.5   # 0.8 ns
time_interval_of_interest=0.01 #0.01ns = 10 ps
intenisty_per_time, intenisty_per_time_normalized = plot_spectra_per_time(negative_time, positive_time, time_interval_of_interest,average_initial_time, map_spectrum_E_red, E_red)
#map_spectrum_E_red_T= plot_spectra_per_time(negative_time, positive_time, time_interval_of_interest, init_time, map_spectrum_E_red, E_red)

#%% Do plot of time decay at different energies
energy_start=0.56 #eV
energy_end=0.91 #eV 
Ttime_start=0.0#-0.16
Ttime_end=2.5#2.5
energy_interval_of_interest=0.01 #eV
intenisty_per_energy, intenisty_per_energy_normalized = plot_intenisty_per_energy(energy_start, energy_end, energy_interval_of_interest, map_spectrum_E_red, E_red, TimeAxis, Ttime_start, Ttime_end, average_initial_time)
#%% Do Fermi Dirac or Boltzmann temperature fit
# # debug (if turned on will display fitting plot of each fit line)
# debug = False
# #### Define how much time before and after the PL peak we want to define the carrier temperature #####
# Ttime_start=0#-0.16 ns
# Ttime_end=2.5#2.5 ns

#   # Type of fit (Boltzman=1 , Fermi Dirac=2)
# Typeoffit = 2
# if Typeoffit == 1:
#    name='Boltzman'
# elif Typeoffit == 2:
#    name='FermiDirac'


# #Te fit done here
# time, carriertemp, carriertemp_error, A1, A1_error, init_energy, chemicalpotential, chemicalpotential_uncer, PL_peak, red_chi = fit_Tefit_TRES(debug, TRES_map_red, TimeAxis, E_red, Ttime_start, Ttime_end, average_initial_time, Typeoffit)
#
# Te_results_df = pd.DataFrame()
# Te_results_df["time (ns)"] = time
# Te_results_df["Carrier temperature (K)"]=carriertemp
# Te_results_df["Uncertainty Carrier temperature (K)"] = carriertemp_error
# Te_results_df["A1"] = A1
# Te_results_df["Uncertainty A1"] = A1_error
# Te_results_df["Initial energy (eV)"] = init_energy
# Te_results_df["chemical potential (ev)"] = chemicalpotential
# Te_results_df["Uncertainty chemical potential (ev)"] = chemicalpotential_uncer
# Te_results_df["PL peak intensity"] = PL_peak
# Te_results_df["reduced chisqr"] = red_chi
#
# if Typeoffit == 1:
#    Te_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Carrier temperature_Boltzmann.csv', index=False)
# elif Typeoffit == 2:
#     Te_results_df.to_csv(save_directory_fitresults + "/" + file_name + '_Carrier temperature_Fermi-Dirac.csv',
#                           index=False)
#
# fig, ax = plt.subplots(figsize=(12, 8))
# ax.scatter(time, carriertemp)
# ax.errorbar(time, carriertemp, yerr=carriertemp_error, fmt="o")
# ax.set_xlabel('Time(ns)', fontweight ='bold')
# ax.set_ylabel('Te (K)', fontweight ='bold')
# ax.set_ylim([0, 1500])
# ax.set_title(file_name+' Carrier temperature per time', fontweight ='bold')
# plt.show()
#%% Do LSW temperature fit
# automatic tuning of initial values (if turned False, fit will be done with automatic initial values, if True, fit will be done with initial values of previous fit)
init_val = True
# debug (if turned on will display fitting plot of each fit line)
debug = False
# Define initial values for the fit
start_energy = 0       
init_E_0_1 = start_energy #start energy
Eg_0_1 = 0.7  # initial band gap energy (eV)
deltamu_0_1 = 0.71  # initial fermi energy (eV)
Tc_0_1 = 54 #initial carrier temperature (K)
A2_0_1 = -22.5 #9E-24
y0_0_1 = 0
w_0_1 = 0.05 # 50 meV broadening

#### Define how much time before and after the PL peak we want to define the carrier temperature #####
Ttime_start=0#-0.16 ns
Ttime_end=2.5#2.5 ns

time, Bandgapenergy, Bandgapenergy_uncer, deltafermi, deltafermi_uncer, Carriertemp, Carriertemp_uncer, A, A_uncer, Finalintenisty, Finalintenisty_uncer, init_energy, chisquart, Broadening, Broadening_error = fit_LSWTefit_TRES(init_val, debug, map_spectrum_E_red, TimeAxis, E_red, Ttime_start, Ttime_end, average_initial_time, init_E_0_1, Eg_0_1,deltamu_0_1, Tc_0_1, A2_0_1, y0_0_1, w_0_1, maxintensitytime)
#np.savetxt(results_path+ file_name+'_carriertemp.txt', np.array((time, Bandgapenergy, Bandgapenergy_uncer, deltafermi, deltafermi_uncer, Carriertemp, Carriertemp_uncer, A, A_uncer, Finalintenisty, Finalintenisty_uncer, init_energy, chisquart)).T, header='Time (ns), Bandgap_energy (eV), Bandgap_energy_uncer (eV), delta_mu (eV), delta_mu_uncer (eV), Carrier_temperature (K), Carrier_temperature_uncer (eV), A2, A2_uncer, Final_intenisty (a.u.), Final_intenisty_uncer (a.u.), initial energy (eV), chisqr', delimiter=',', fmt='%s')

fig, ax = plt.subplots(figsize=(12, 8))
ax.set_xlabel('Time (ns)', fontweight ='bold',fontsize=30)
ax.set_ylabel('Carrier temperature (K)', fontweight ='bold',fontsize=30)
ax.set_title(file_name+' Carrier temperature per time', fontweight ='bold',fontsize=15)
ax.scatter(time, Carriertemp)
ax.errorbar(time, Carriertemp, yerr=Carriertemp_uncer, fmt="o")
plt.savefig(save_directory_metadata+"/Fit_LSW_CarrierT.png")
plt.show()

LSW_results_df = pd.DataFrame()
LSW_results_df["time (ns)"] = time
LSW_results_df["Band gap energy (eV)"]=Bandgapenergy
LSW_results_df["Uncertainty Band gap energy (eV)"] = Bandgapenergy_uncer
LSW_results_df["chemical potential (ev)"] = deltafermi
LSW_results_df["Uncertainty chemical potential (ev)"] = deltafermi_uncer
LSW_results_df["Carrier temperature (K)"]= Carriertemp
LSW_results_df["Uncertainty Carrier temperature (K)"] = Carriertemp_uncer
LSW_results_df["A2"] = A
LSW_results_df["Uncertainty A2"] = A_uncer
LSW_results_df["y0 (a.u.)"]= Finalintenisty
LSW_results_df["Uncertainty y0 (a.u.)"] = Finalintenisty_uncer
LSW_results_df["x0 (eV)"] = init_energy
LSW_results_df["reduced chisqr"] = chisquart
LSW_results_df["Broadening (eV)"] = Broadening
LSW_results_df["Broadening error (eV)"] = Broadening_error

LSW_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Carrier temperature_LSW.csv', index=False)
# #%% Lifetime fit
# # debug (if turned on will display fitting plot of each fit line)
# debug = False
# # Number of decay channels to fit (monoexponent N=1 , biexponent N=2), only N=1 implemented for now
# N_decaychannels = 1
#
# TRES_map=map_spectrum_E
# time_axis=TimeAxis
# energy_axis=E
# time_start=0
# time_end=4
# energy_start=0.65
# energy_end=0.70
#
# energy, lifetimes, lifetimes_error, channelstrengths, channelstrengths_error, init_times, chi_sqrs, lifetimes_2, lifetimes_error_2, channelstrengths_2, channelstrengths_error_2=fit_lifetimes_TRES(N_decaychannels, debug, TRES_map, time_axis, energy_axis, time_start, time_end, energy_start, energy_end)
#
# fig, ax = plt.subplots(figsize=(12, 8))
# ax.scatter(energy, lifetimes)
# ax.errorbar(energy, lifetimes, yerr=lifetimes_error, fmt="o")
# ax.set_xlabel('Energy (eV)', fontweight ='bold')
# ax.set_ylabel('Lifetime (ns)', fontweight ='bold')
# ax.set_ylim([0, 3])
# ax.set_title(file_name+' Lifetime per energy', fontweight ='bold')
# plt.show()
#
# fig, ax = plt.subplots(figsize=(12, 8))
# ax.scatter(energy, lifetimes_2)
# ax.errorbar(energy, lifetimes_2, yerr=lifetimes_error_2, fmt="o")
# ax.set_xlabel('Energy (eV)', fontweight ='bold')
# ax.set_ylabel('Lifetime_2 (ns)', fontweight ='bold')
# ax.set_ylim([0, 10])
# ax.set_title(file_name+' Lifetime_2 per energy', fontweight ='bold')
#
# fig, ax = plt.subplots(figsize=(12, 8))
# ax.scatter(energy, chi_sqrs)
# #ax.errorbar(energy, lifetimes_2, yerr=lifetimes_error_2, fmt="o")
# ax.set_xlabel('Energy (eV)', fontweight ='bold')
# ax.set_ylabel('chisquared', fontweight ='bold')
# #ax.set_ylim([0, 10])
# ax.set_title(file_name+' chisquared per energy', fontweight ='bold')
#
# Lifetime_results_df = pd.DataFrame()
# Lifetime_results_df["energy (eV)"] = energy
# Lifetime_results_df["lifetime_1 (ns)"]=lifetimes
# Lifetime_results_df["Uncertainty lifetime_1 (ns)"] = lifetimes_error
# Lifetime_results_df["Channel strength_1"] = channelstrengths
# Lifetime_results_df["Uncertainty Channel strength_1"] = channelstrengths_error
# Lifetime_results_df["Initial times (ns)"]= init_times
# Lifetime_results_df["chi squared"] = chi_sqrs
# Lifetime_results_df["lifetime_2 (ns)"] = lifetimes_2
# Lifetime_results_df["Uncertainty lifetime_2 (ns)"] = lifetimes_error_2
# Lifetime_results_df["Channel strength_2"]= channelstrengths_2
# Lifetime_results_df["Uncertainty Channel strength_2"] = channelstrengths_error_2
#
# if N_decaychannels == 1:
#     Lifetime_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Lifetime_fit_monoexponential.csv', index=False)
# elif Typeoffit == 2:
#     Lifetime_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Lifetime_fit_biexponential.csv', index=False)
#
# # Lifetime_results_df.to_csv(save_directory_fitresults+"/"+file_name+'_Lifetime_fit_biexponential.csv', index=False)
# #%% Second derivative spectrum
#
#
# #%% Aanroepen 2nd defivative fit
# Ttime_start=0.2#-0.16
# Ttime_end=0.6#1
# average_initial_time=np.nanmean(init_time) #init_time comes from lifetime fit
#
# #energy_axis_red=1239.8/wavelength_axis_red
# Tenergy_start=0.64 #eV of peak of integrated spectrum
# Tenergy_end=np.max(E_red)
#
# time, Bandgapenergy, Bandgapenergy_uncer, deltafermi, deltafermi_uncer, Carriertemp, Carriertemp_uncer, A, A_uncer, Finalintenisty, Finalintenisty_uncer, init_energy, chisquart = fit_LSWTefit_v2_TRES(map_spectrum_E_red, TimeAxis, E_red, Ttime_start, Ttime_end, average_initial_time)

# #%%Inegrate spectrum after 1ns-2.5 ns
#
# inttimestart=1; #ns
# inttimeend=2.5; #ns
#  # Select to the times wanted to fit Te to
# inttimestart_real=average_initial_time+inttimestart
# inttimeend_real=average_initial_time+inttimeend
#
# time_axis = TimeAxis/1000  # converts ps time axis to ns
# time_res = (time_axis[4] - time_axis[3]) #in ns
#
# start_element_time = time_to_element(inttimestart_real, time_res)
# start_element_time = start_element_time.astype(int)
# end_element_time = time_to_element(inttimeend_real, time_res)
# end_element_time = end_element_time.astype(int)
#
# Spectrum = np.sum(map_spectrum_E_red[:,start_element_time:end_element_time], axis=1)
# if plot_prompt is True:
#     plt.plot(E_red, Spectrum, label="Integrated spectrum 1-2.5 ns")
#     plt.title(file_name, fontweight ='bold')
#     plt.xlabel('Energy (eV)')
#     plt.ylabel('Intensity (a.u.)')
#     plt.legend()
#     plt.show()
#
# maxintenisity_spectrum=np.max(Spectrum)
# maxintensity_spectrum_element=findNearest(Spectrum, maxintenisity_spectrum)
# maxintensity_spectrum_energy=E[maxintensity_spectrum_element]
#
# NormalizedSpectrum = Spectrum / np.max(Spectrum)
#
# #Spectrum_80_15000uw=Spectrum
# #NormalizedSpectrum_80_15000uw=NormalizedSpectrum
#
# np.savetxt(save_directory_fitresults+"/"+file_name+'_averaged_spectrum_1_2.5_ns.txt', np.array((E_red, Spectrum, NormalizedSpectrum)).T, header='Energy (eV), Integrated intensity (a.u.), Integrated intensity normalized (a.u.)',delimiter=',')
#
# # start_element_time_2=findNearest(time, inttimestart)
# # end_element_time_2=findNearest(time, inttimeend)
# # averageTc=np.average(Carriertemp[start_element_time_2:end_element_time_2])
# # print(averageTc)
# #%%Inegrate spectrum after 1ns-1.5 ns
#
# inttimestart=1; #ns
# inttimeend=1.5; #ns
#  # Select to the times wanted to fit Te to
# inttimestart_real=average_initial_time+inttimestart
# inttimeend_real=average_initial_time+inttimeend
#
# time_axis = TimeAxis/1000  # converts ps time axis to ns
# time_res = (time_axis[4] - time_axis[3]) #in ns
#
# start_element_time = time_to_element(inttimestart_real, time_res)
# start_element_time = start_element_time.astype(int)
# end_element_time = time_to_element(inttimeend_real, time_res)
# end_element_time = end_element_time.astype(int)
#
# Spectrum = np.sum(map_spectrum_E_red[:,start_element_time:end_element_time], axis=1)
# if plot_prompt is True:
#     plt.plot(E_red, Spectrum, label="Integrated spectrum 1-1.5 ns")
#     plt.title(file_name, fontweight ='bold')
#     plt.xlabel('Energy (eV)')
#     plt.ylabel('Intensity (a.u.)')
#     plt.legend()
#     plt.show()
#
# maxintenisity_spectrum=np.max(Spectrum)
# maxintensity_spectrum_element=findNearest(Spectrum, maxintenisity_spectrum)
# maxintensity_spectrum_energy=E[maxintensity_spectrum_element]
#
# NormalizedSpectrum = Spectrum / np.max(Spectrum)
#
# #Spectrum_80_15000uw=Spectrum
# #NormalizedSpectrum_80_15000uw=NormalizedSpectrum
#
# np.savetxt(save_directory_fitresults+"/"+file_name+'_averaged_spectrum_1_1.5_ns.txt', np.array((E_red, Spectrum, NormalizedSpectrum)).T, header='Energy (eV), Integrated intensity (a.u.), Integrated intensity normalized (a.u.)',delimiter=',')
#
# # start_element_time_2=findNearest(time, inttimestart)
# # end_element_time_2=findNearest(time, inttimeend)
# # averageTc=np.average(Carriertemp[start_element_time_2:end_element_time_2])
# # print(averageTc)
#
# #%% Plot
# spectra_1_2_5ns_df = pd.DataFrame()
# spectra_1_2_5ns_df["energy(eV)"] = E
# spectra_1_2_5ns_df["40000uW"] = Spectrum_40mw
# spectra_1_2_5ns_df["40000uW_normalized"] = NormalizedSpectrum_40mW
# spectra_1_2_5ns_df["30000uW"] = Spectrum_30mw
# spectra_1_2_5ns_df["30000uW_normalized"] = NormalizedSpectrum_30mW
# spectra_1_2_5ns_df["20000uW"] = Spectrum_30mw
# spectra_1_2_5ns_df["20000uW_normalized"] = NormalizedSpectrum_20mW
# spectra_1_2_5ns_df["15000uW"] = Spectrum_15mw
# spectra_1_2_5ns_df["15000uW_normalized"] = NormalizedSpectrum_15mW
# spectra_1_2_5ns_df["12500uW"] = Spectrum_12500uw
# spectra_1_2_5ns_df["12500uW_normalized"] = NormalizedSpectrum_12500uw
# spectra_1_2_5ns_df["10000uW"] = Spectrum_10000uw
# spectra_1_2_5ns_df["10000uW_normalized"] = NormalizedSpectrum_10000uw
# spectra_1_2_5ns_df["7500uW"] = Spectrum_7500uw
# spectra_1_2_5ns_df["7500uW_normalized"] = NormalizedSpectrum_7500uw
# spectra_1_2_5ns_df["5000uW"] = Spectrum_5000uw
# spectra_1_2_5ns_df["5000uW_normalized"] = NormalizedSpectrum_5000uw
# spectra_1_2_5ns_df["3500uW"] = Spectrum_3500uw
# spectra_1_2_5ns_df["3500uW_normalized"] = NormalizedSpectrum_3500uw
# spectra_1_2_5ns_df["2000uW"] = Spectrum_2000uw
# spectra_1_2_5ns_df["2000uW_normalized"] = NormalizedSpectrum_2000uw
# spectra_1_2_5ns_df["1500uW"] = Spectrum_1500uw
# spectra_1_2_5ns_df["1500uW_normalized"] = NormalizedSpectrum_1500uw
# spectra_1_2_5ns_df["1000uW"] = Spectrum_1000uw
# spectra_1_2_5ns_df["1000uW_normalized"] = NormalizedSpectrum_1000uw
# spectra_1_2_5ns_df["750uW"] = Spectrum_750uw
# spectra_1_2_5ns_df["750uW_normalized"] = NormalizedSpectrum_750uw
# spectra_1_2_5ns_df["500uW"] = Spectrum_500uw
# spectra_1_2_5ns_df["500uW_normalized"] = NormalizedSpectrum_500uw
# spectra_1_2_5ns_df["300uW"] = Spectrum_300uw
# spectra_1_2_5ns_df["300uW_normalized"] = NormalizedSpectrum_300uw
# spectra_1_2_5ns_df["200uW"] = Spectrum_200uw
# spectra_1_2_5ns_df["200uW_normalized"] = NormalizedSpectrum_200uw
#
# spectra_1_2_5ns_df.to_csv(save_directory_fitresults+"/"+file_name+'_spectra_1_2_5ns.csv', index=False)
# #%%
# carrierT_array=np.array([averageTc_40mW,averageTc_30mW,averageTc_20mW,averageTc_15mW,averageTc_12500uw,averageTc_10000uw,averageTc_7500uw,averageTc_5000uw,averageTc_3500uw,averageTc_2000uw,averageTc_1500uw,averageTc_1000uw,averageTc_750uw,averageTc_500uw,averageTc_300uw,averageTc_200uw])
# fluence_array=np.array([4.5910E15,3.4433E15,2.29553E15,1.72165E15,1.43471E15,1.14777E15,8.60824E14,5.73883E14,4.01718E14,2.29553E14,1.72165E14,1.14777E14,8.60824E13,5.73883E13,3.4433E13,2.29553E13])
# P_array=np.array([40000,30000,20000,15000,12500,10000,7500,5000,3500,2000,1500,1000,750,500,300,200])
#
# avgTc_1_2_5ns_df = pd.DataFrame()
# avgTc_1_2_5ns_df["power(uW)"] = P_array
# avgTc_1_2_5ns_df["fluence(photons/cm^2)"] = fluence_array
# avgTc_1_2_5ns_df["average Tc 1to2.5 ns"] = carrierT_array
#
# avgTc_1_2_5ns_df.to_csv(save_directory_fitresults+"/"+file_name+'_averageTc_1_2_5ns.csv', index=False)
# #%%
# spectra_80_04_08ns_df = pd.DataFrame()
# spectra_80_04_08ns_df["energy(eV)"] = E
# spectra_80_04_08ns_df["15000uW"] = Spectrum_80_15mw
# spectra_80_04_08ns_df["15000uW_normalized"] = NormalizedSpectrum_80_15mw
# spectra_80_04_08ns_df["10000uW"] = Spectrum_80_10000uw
# spectra_80_04_08ns_df["10000uW_normalized"] = NormalizedSpectrum_80_10000uw
# spectra_80_04_08ns_df["1000uW"] = Spectrum_80_1000uw
# spectra_80_04_08ns_df["1000uW_normalized"] = NormalizedSpectrum_80_1000uw
# spectra_80_04_08ns_df["500uW"] = Spectrum_80_500uw
# spectra_80_04_08ns_df["500uW_normalized"] = NormalizedSpectrum_80_500uw
#
# spectra_80_04_08ns_df.to_csv(save_directory_fitresults+"/"+file_name+'_spectra_80_04_08ns.csv', index=False)
#
# #%%
# carrierT_array=np.array([averageTc_80_15mw,averageTc_80_10000uw,averageTc_80_10000uw,averageTc_80_10000uw])
# fluence_array=np.array([1.72165E15,1.14777E15,1.14777E14,5.73883E13])
# P_array=np.array([15000,10000,1000,500])
#
# avgTc_80_04_08ns_df = pd.DataFrame()
# avgTc_80_04_08ns_df["power(uW)"] = P_array
# avgTc_80_04_08ns_df["fluence(photons/cm^2)"] = fluence_array
# avgTc_80_04_08ns_df["average Tc 1to2.5 ns"] = carrierT_array
#
# avgTc_80_04_08ns_df.to_csv(save_directory_fitresults+"/"+file_name+'_averageTc_80_04_08ns.csv', index=False)